/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.overworld;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.config.IBOPWorldSettings;
import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.api.enums.BOPFlowers;
import biomesoplenty.api.enums.BOPGems;
import biomesoplenty.api.enums.BOPPlants;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.enums.BOPWoods;
import biomesoplenty.api.generation.GeneratorStage;
import biomesoplenty.common.biome.BOPBiome;
import biomesoplenty.common.biome.overworld.BOPOverworldBiome;
import biomesoplenty.common.block.BlockBOPDirt;
import biomesoplenty.common.block.BlockBOPGrass;
import biomesoplenty.common.entities.EntityButterfly;
import biomesoplenty.common.world.generator.GeneratorFlora;
import biomesoplenty.common.world.generator.GeneratorGrass;
import biomesoplenty.common.world.generator.GeneratorOreSingle;
import biomesoplenty.common.world.generator.GeneratorWeighted;
import biomesoplenty.common.world.generator.tree.GeneratorBasicTree;
import biomesoplenty.common.world.generator.tree.GeneratorBigTree;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;

public class BiomeGenLavenderFields
extends BOPOverworldBiome {
    public BiomeGenLavenderFields() {
        super("lavender_fields", new BOPBiome.PropsBuilder("Lavender Fields").withGuiColour(11035852).withTemperature(Float.valueOf(0.7f)).withRainfall(Float.valueOf(0.7f)));
        this.terrainSettings.avgHeight(64.0).heightVariation(4.0, 12.0);
        this.field_76752_A = BOPBlocks.grass.func_176223_P().func_177226_a((IProperty)BlockBOPGrass.VARIANT, (Comparable)((Object)BlockBOPGrass.BOPGrassType.SILTY));
        this.field_76753_B = BOPBlocks.dirt.func_176223_P().func_177226_a((IProperty)BlockBOPDirt.VARIANT, (Comparable)((Object)BlockBOPDirt.BOPDirtType.SILTY));
        this.canSpawnInBiome = false;
        this.canGenerateVillages = false;
        this.addWeight(BOPClimates.MEDITERANEAN, 3);
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityButterfly.class, 6, 2, 4));
        this.addGenerator("lavender", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(50.0f)).with(BOPFlowers.LAVENDER)).create());
        GeneratorWeighted treeGenerator = new GeneratorWeighted(1.0f);
        this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
        treeGenerator.add("jacaranda", 3, ((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)new GeneratorBasicTree.Builder().minHeight(4)).maxHeight(7)).log(BOPWoods.JACARANDA)).leaves(BOPTrees.JACARANDA)).create());
        treeGenerator.add("oak", 1, ((GeneratorBigTree.Builder)new GeneratorBigTree.Builder().altLeaves(BOPTrees.FLOWERING)).create());
        GeneratorWeighted grassGenerator = new GeneratorWeighted(15.0f);
        this.addGenerator("grass", GeneratorStage.GRASS, grassGenerator);
        grassGenerator.add("shortgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.SHORTGRASS)).create());
        grassGenerator.add("mediumgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.MEDIUMGRASS)).create());
        grassGenerator.add("wheatgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.WHEATGRASS)).create());
        grassGenerator.add("tallgrass", 3, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BlockTallGrass.EnumType.GRASS)).create());
        this.addGenerator("peridot", GeneratorStage.SAND, ((GeneratorOreSingle.Builder)((GeneratorOreSingle.Builder)new GeneratorOreSingle.Builder().amountPerChunk(12.0f)).with(BOPGems.PERIDOT)).create());
    }

    @Override
    public void applySettings(IBOPWorldSettings settings) {
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.MUSHROOMS)) {
            this.removeGenerator("glowshrooms");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.FLOWERS)) {
            this.removeGenerator("miners_delight");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.ROCK_FORMATIONS)) {
            this.removeGenerator("stone_formations");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.GEMS)) {
            this.removeGenerator("peridot");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.SOILS)) {
            this.field_76752_A = Blocks.field_150349_c.func_176223_P();
            this.field_76753_B = Blocks.field_150346_d.func_176223_P();
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.PLANTS)) {
            this.removeGenerator("cattail");
            this.removeGenerator("double_cattail");
            this.removeGenerator("river_cane");
            this.removeGenerator("tiny_cacti");
            this.removeGenerator("roots");
            this.removeGenerator("rafflesia");
            this.removeGenerator("desert_sprouts");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.FOLIAGE)) {
            this.removeGenerator("bushes");
            this.removeGenerator("koru");
            this.removeGenerator("shrubs");
            this.removeGenerator("leaf_piles");
            this.removeGenerator("dead_leaf_piles");
            this.removeGenerator("clover_patches");
            this.removeGenerator("sprouts");
        }
        GeneratorWeighted treeGen = (GeneratorWeighted)this.getGenerator("trees");
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.TREES)) {
            this.removeGenerator("trees");
            GeneratorWeighted treeGenerator = new GeneratorWeighted(1.0f);
            this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
            treeGenerator.add("jacaranda", 3, ((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)new GeneratorBasicTree.Builder().minHeight(4)).maxHeight(7)).create());
            treeGenerator.add("oak", 1, new GeneratorBigTree.Builder().create());
        }
        GeneratorWeighted grassGen = (GeneratorWeighted)this.getGenerator("grass");
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.GRASSES)) {
            grassGen.removeGenerator("shortgrass");
            grassGen.removeGenerator("mediumgrass");
            grassGen.removeGenerator("wheatgrass");
            grassGen.removeGenerator("dampgrass");
        }
    }

    public int func_180627_b(BlockPos pos) {
        return 10601325;
    }

    public int func_180625_c(BlockPos pos) {
        return 10601325;
    }
}

