/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.overworld;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.api.config.IBOPWorldSettings;
import biomesoplenty.api.enums.BOPGems;
import biomesoplenty.api.generation.GeneratorStage;
import biomesoplenty.common.biome.BOPBiome;
import biomesoplenty.common.biome.overworld.BOPOverworldBiome;
import biomesoplenty.common.block.BlockBOPCoral;
import biomesoplenty.common.util.biome.BiomeUtils;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.world.generator.GeneratorColumns;
import biomesoplenty.common.world.generator.GeneratorFlora;
import biomesoplenty.common.world.generator.GeneratorOreSingle;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;

public class BiomeGenKelpForest
extends BOPOverworldBiome {
    public BiomeGenKelpForest() {
        super("kelp_forest", new BOPBiome.PropsBuilder("Kelp Forest").withGuiColour(27468));
        this.terrainSettings.avgHeight(40.0).heightVariation(5.0, 5.0);
        this.canSpawnInBiome = false;
        this.canGenerateVillages = false;
        this.canGenerateRivers = false;
        this.hasBiomeEssence = false;
        this.beachBiomeLocation = BiomeUtils.getLocForBiome(Biomes.field_76771_b);
        this.clearWeights();
        this.addGenerator("algae", GeneratorStage.LILYPAD, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(3.0f)).replace((Block)Blocks.field_150355_j)).with(BOPBlocks.coral.func_176223_P().func_177226_a((IProperty)BlockBOPCoral.VARIANT, (Comparable)((Object)BlockBOPCoral.CoralType.ALGAE)))).scatterYMethod(GeneratorUtils.ScatterYMethod.AT_GROUND)).create());
        this.addGenerator("kelp", GeneratorStage.LILYPAD, ((GeneratorColumns.Builder)((GeneratorColumns.Builder)((GeneratorColumns.Builder)((GeneratorColumns.Builder)((GeneratorColumns.Builder)new GeneratorColumns.Builder().amountPerChunk(5.0f)).replace(BlockQueries.waterCovered)).placeOn(BlockQueries.groundBlocks)).with(BOPBlocks.seaweed.func_176223_P())).scatterYMethod(GeneratorUtils.ScatterYMethod.AT_GROUND)).create());
        this.addGenerator("kelp_tall", GeneratorStage.LILYPAD, ((GeneratorColumns.Builder)((GeneratorColumns.Builder)((GeneratorColumns.Builder)((GeneratorColumns.Builder)((GeneratorColumns.Builder)new GeneratorColumns.Builder().amountPerChunk(6.0f)).replace(BlockQueries.waterCovered)).placeOn(BlockQueries.groundBlocks)).with(BOPBlocks.seaweed.func_176223_P())).minHeight(6).maxHeight(12).scatterYMethod(GeneratorUtils.ScatterYMethod.AT_GROUND)).create());
        this.addGenerator("sapphire", GeneratorStage.SAND, ((GeneratorOreSingle.Builder)((GeneratorOreSingle.Builder)new GeneratorOreSingle.Builder().amountPerChunk(12.0f)).with(BOPGems.SAPPHIRE)).create());
    }

    @Override
    public void applySettings(IBOPWorldSettings settings) {
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.MUSHROOMS)) {
            this.removeGenerator("glowshrooms");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.FLOWERS)) {
            this.removeGenerator("miners_delight");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.ROCK_FORMATIONS)) {
            this.removeGenerator("stone_formations");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.GEMS)) {
            this.removeGenerator("sapphire");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.FOLIAGE)) {
            this.removeGenerator("bushes");
            this.removeGenerator("koru");
            this.removeGenerator("shrubs");
            this.removeGenerator("leaf_piles");
            this.removeGenerator("dead_leaf_piles");
            this.removeGenerator("clover_patches");
            this.removeGenerator("sprouts");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.PLANTS)) {
            this.removeGenerator("cattail");
            this.removeGenerator("double_cattail");
            this.removeGenerator("river_cane");
            this.removeGenerator("tiny_cacti");
            this.removeGenerator("roots");
            this.removeGenerator("rafflesia");
            this.removeGenerator("desert_sprouts");
        }
    }
}

