/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.overworld;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.api.config.IBOPWorldSettings;
import biomesoplenty.api.config.IConfigObj;
import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.api.enums.BOPGems;
import biomesoplenty.api.enums.BOPPlants;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.generation.GeneratorStage;
import biomesoplenty.common.biome.BOPBiome;
import biomesoplenty.common.biome.overworld.BOPOverworldBiome;
import biomesoplenty.common.block.BlockBOPCoral;
import biomesoplenty.common.block.BlockBOPPlant;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.world.generator.GeneratorColumns;
import biomesoplenty.common.world.generator.GeneratorDoubleFlora;
import biomesoplenty.common.world.generator.GeneratorFlora;
import biomesoplenty.common.world.generator.GeneratorGrass;
import biomesoplenty.common.world.generator.GeneratorOreSingle;
import biomesoplenty.common.world.generator.GeneratorWeighted;
import biomesoplenty.common.world.generator.tree.GeneratorBulbTree;
import biomesoplenty.common.world.generator.tree.GeneratorTwigletTree;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;

public class BiomeGenBambooForest
extends BOPOverworldBiome {
    public IBlockState usualTopBlock;
    public IBlockState alternateTopBlock;

    public BiomeGenBambooForest() {
        super("bamboo_forest", new BOPBiome.PropsBuilder("Bamboo Forest").withGuiColour(10739795).withRainfall(Float.valueOf(0.85f)).withTemperature(Float.valueOf(0.9f)));
        this.terrainSettings.avgHeight(68.0).heightVariation(5.0, 10.0);
        this.canGenerateVillages = false;
        this.addWeight(BOPClimates.TROPICAL, 3);
        this.field_76762_K.clear();
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityOcelot.class, 2, 1, 1));
        this.usualTopBlock = this.field_76752_A = Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL);
        this.alternateTopBlock = Blocks.field_150349_c.func_176223_P();
        GeneratorWeighted flowerGenerator = new GeneratorWeighted(0.5f);
        this.addGenerator("flowers", GeneratorStage.FLOWERS, flowerGenerator);
        flowerGenerator.add("dandelion", 1, ((GeneratorFlora.Builder)new GeneratorFlora.Builder().with(BlockFlower.EnumFlowerType.DANDELION)).create());
        flowerGenerator.add("poppy", 1, ((GeneratorFlora.Builder)new GeneratorFlora.Builder().with(BlockFlower.EnumFlowerType.POPPY)).create());
        GeneratorWeighted treeGenerator = new GeneratorWeighted(30.0f);
        this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
        treeGenerator.add("bamboo", 3, ((GeneratorBulbTree.Builder)((GeneratorBulbTree.Builder)((GeneratorBulbTree.Builder)((GeneratorBulbTree.Builder)new GeneratorBulbTree.Builder().minHeight(10)).maxHeight(20)).log(BOPBlocks.bamboo.func_176223_P())).leaves(BOPTrees.BAMBOO)).create());
        treeGenerator.add("bamboo_thin", 1, ((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)new GeneratorTwigletTree.Builder().minHeight(5)).maxHeight(10)).leafChance(0.3f).log(BOPBlocks.bamboo.func_176223_P())).leaves(BOPTrees.BAMBOO)).create());
        GeneratorWeighted grassGenerator = new GeneratorWeighted(2.6f);
        this.addGenerator("grass", GeneratorStage.GRASS, grassGenerator);
        grassGenerator.add("shortgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.SHORTGRASS)).create());
        grassGenerator.add("mediumgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.MEDIUMGRASS)).create());
        grassGenerator.add("dampgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.DAMPGRASS)).create());
        grassGenerator.add("tallgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BlockTallGrass.EnumType.GRASS)).create());
        grassGenerator.add("doublegrass", 2, new GeneratorDoubleFlora.Builder().with(BlockDoublePlant.EnumPlantType.GRASS).create());
        this.addGenerator("leaf_piles", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(3.0f)).placeOn(BlockQueries.fertile)).with(BOPPlants.LEAFPILE)).create());
        this.addGenerator("ferns", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(4.0f)).with(BlockTallGrass.EnumType.FERN)).create());
        this.addGenerator("river_cane", GeneratorStage.FLOWERS, ((GeneratorColumns.Builder)((GeneratorColumns.Builder)((GeneratorColumns.Builder)new GeneratorColumns.Builder().amountPerChunk(5.0f)).generationAttempts(24).placeOn(BlockQueries.litFertileWaterside)).with(BlockBOPPlant.paging.getVariantState(BOPPlants.RIVERCANE))).minHeight(1).maxHeight(3).create());
        this.addGenerator("algae", GeneratorStage.LILYPAD, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(4.0f)).replace((Block)Blocks.field_150355_j)).with(BOPBlocks.coral.func_176223_P().func_177226_a((IProperty)BlockBOPCoral.VARIANT, (Comparable)((Object)BlockBOPCoral.CoralType.ALGAE)))).scatterYMethod(GeneratorUtils.ScatterYMethod.AT_GROUND)).create());
        this.addGenerator("bushes", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.5f)).with(BOPPlants.BUSH)).create());
        this.addGenerator("topaz", GeneratorStage.SAND, ((GeneratorOreSingle.Builder)((GeneratorOreSingle.Builder)new GeneratorOreSingle.Builder().amountPerChunk(12.0f)).with(BOPGems.TOPAZ)).create());
    }

    @Override
    public void configure(IConfigObj conf) {
        super.configure(conf);
        this.usualTopBlock = this.field_76752_A;
        this.alternateTopBlock = conf.getBlockState("alternateTopBlock", this.alternateTopBlock);
    }

    @Override
    public void applySettings(IBOPWorldSettings settings) {
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.MUSHROOMS)) {
            this.removeGenerator("glowshrooms");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.FLOWERS)) {
            this.removeGenerator("miners_delight");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.ROCK_FORMATIONS)) {
            this.removeGenerator("stone_formations");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.GEMS)) {
            this.removeGenerator("topaz");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.FOLIAGE)) {
            this.removeGenerator("bushes");
            this.removeGenerator("koru");
            this.removeGenerator("shrubs");
            this.removeGenerator("leaf_piles");
            this.removeGenerator("dead_leaf_piles");
            this.removeGenerator("clover_patches");
            this.removeGenerator("sprouts");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.PLANTS)) {
            this.removeGenerator("cattail");
            this.removeGenerator("double_cattail");
            this.removeGenerator("river_cane");
            this.removeGenerator("tiny_cacti");
            this.removeGenerator("roots");
            this.removeGenerator("rafflesia");
            this.removeGenerator("desert_sprouts");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.WATER_PLANTS)) {
            this.removeGenerator("algae");
            this.removeGenerator("water_reeds");
            this.removeGenerator("medium_lily");
            this.removeGenerator("small_lily");
            this.removeGenerator("tiny_lily");
        }
        GeneratorWeighted grassGen = (GeneratorWeighted)this.getGenerator("grass");
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.GRASSES)) {
            grassGen.removeGenerator("shortgrass");
            grassGen.removeGenerator("mediumgrass");
            grassGen.removeGenerator("wheatgrass");
            grassGen.removeGenerator("dampgrass");
        }
    }

    @Override
    public void func_180622_a(World world, Random rand, ChunkPrimer primer, int x, int z, double noise) {
        this.field_76752_A = noise + rand.nextDouble() * 3.0 > 1.8 ? this.alternateTopBlock : this.usualTopBlock;
        super.func_180622_a(world, rand, primer, x, z, noise);
    }

    public int func_180627_b(BlockPos pos) {
        return 12311892;
    }

    public int func_180625_c(BlockPos pos) {
        return 12311892;
    }
}

