/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.overworld;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.block.IBlockPosQuery;
import biomesoplenty.api.config.IBOPWorldSettings;
import biomesoplenty.api.config.IConfigObj;
import biomesoplenty.api.enums.BOPFlowers;
import biomesoplenty.api.enums.BOPPlants;
import biomesoplenty.api.generation.GeneratorStage;
import biomesoplenty.common.biome.BOPBiome;
import biomesoplenty.common.block.BlockBOPMushroom;
import biomesoplenty.common.init.ModBiomes;
import biomesoplenty.common.util.biome.BiomeUtils;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.world.TerrainSettings;
import biomesoplenty.common.world.generator.GeneratorColumns;
import biomesoplenty.common.world.generator.GeneratorFlora;
import biomesoplenty.core.BiomesOPlenty;
import java.util.Random;
import net.minecraft.block.BlockSand;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;

public class BOPOverworldBiome
extends BOPBiome {
    public IBlockState seaFloorBlock = Blocks.field_150346_d.func_176223_P();
    public boolean canSpawnInBiome = true;
    public boolean canGenerateVillages = true;
    public boolean canGenerateRivers = true;
    public ResourceLocation beachBiomeLocation = BiomeUtils.getLocForBiome(Biomes.field_76787_r);
    public TerrainSettings terrainSettings = new TerrainSettings();
    public boolean noNeighborTerrainInfuence = false;
    public int avgDirtDepth = 3;

    public BOPOverworldBiome(String idName, BOPBiome.PropsBuilder defaultBuilder) {
        super(idName, defaultBuilder);
        this.terrainSettings.setDefaults();
        this.field_76760_I.field_76832_z = -999;
        this.field_76760_I.field_76802_A = -999;
        this.field_76760_I.field_76803_B = -999;
        this.field_76760_I.field_76801_G = -999;
        this.field_76760_I.field_76805_H = -999;
        this.addGenerator("roots", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(4.0f)).with(BOPPlants.ROOT)).create());
        IBlockPosQuery suitableStonePosition = BlockQuery.buildAnd().withAltitudeBetween(0, 55).blocks(Blocks.field_150348_b).create();
        this.addGenerator("miners_delight", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.25f)).generationAttempts(64)).with(BOPFlowers.MINERS_DELIGHT)).placeOn(suitableStonePosition)).scatterYMethod(GeneratorUtils.ScatterYMethod.BELOW_GROUND)).create());
        this.addGenerator("glowshrooms", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(1.5f)).generationAttempts(64)).placeOn(suitableStonePosition)).with(BOPBlocks.mushroom.func_176223_P().func_177226_a((IProperty)BlockBOPMushroom.VARIANT, (Comparable)((Object)BlockBOPMushroom.MushroomType.GLOWSHROOM)))).scatterYMethod(GeneratorUtils.ScatterYMethod.BELOW_GROUND)).create());
        this.addGenerator("stone_formations", GeneratorStage.FLOWERS, ((GeneratorColumns.Builder)((GeneratorColumns.Builder)((GeneratorColumns.Builder)((GeneratorColumns.Builder)new GeneratorColumns.Builder().amountPerChunk(30.0f)).generationAttempts(32).placeOn(suitableStonePosition)).with(BOPBlocks.stone_formations.func_176223_P())).minHeight(1).maxHeight(5).randomDirection(true).scatterYMethod(GeneratorUtils.ScatterYMethod.BELOW_GROUND)).create());
    }

    @Override
    public void applySettings(IBOPWorldSettings settings) {
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.MUSHROOMS)) {
            this.removeGenerator("glowshrooms");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.PLANTS)) {
            this.removeGenerator("roots");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.FLOWERS)) {
            this.removeGenerator("miners_delight");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.ROCK_FORMATIONS)) {
            this.removeGenerator("stone_formations");
        }
    }

    @Override
    public void configure(IConfigObj conf) {
        super.configure(conf);
        this.seaFloorBlock = conf.getBlockState("seaFloorBlock", this.seaFloorBlock);
        this.terrainSettings.avgHeight = conf.getFloat("averageHeight", Float.valueOf((float)this.terrainSettings.avgHeight)).floatValue();
        this.terrainSettings.variationBelow = conf.getFloat("variationBelow", Float.valueOf((float)this.terrainSettings.variationBelow)).floatValue();
        this.terrainSettings.variationAbove = conf.getFloat("variationAbove", Float.valueOf((float)this.terrainSettings.variationAbove)).floatValue();
        this.canSpawnInBiome = conf.getBool("canSpawnInBiome", this.canSpawnInBiome);
        this.canGenerateVillages = conf.getBool("canGenerateVillages", this.canGenerateVillages);
        this.canGenerateRivers = conf.getBool("canGenerateRivers", this.canGenerateRivers);
        this.beachBiomeLocation = conf.getResourceLocation("beachBiomeLocation", this.beachBiomeLocation);
        for (String msg : conf.flushMessages()) {
            BiomesOPlenty.logger.info(msg);
        }
        ModBiomes.writeDefaultConfigFile(ModBiomes.BOP_DEFAULTS_DIR, this.getResourceLocation().func_110623_a(), conf);
    }

    public void func_180622_a(World world, Random rand, ChunkPrimer primer, int x, int z, double stoneNoiseVal) {
        IBlockState topBlock = this.field_76752_A;
        IBlockState fillerBlock = this.field_76753_B;
        IBlockState seaFloorBlock = this.seaFloorBlock;
        boolean hitFloorYet = false;
        int topBlocksToFill = 0;
        int dirtBlocksToFill = 0;
        int seaFloorBlocksToFill = 0;
        int dirtDepth = Math.max(0, (int)(stoneNoiseVal / 3.0 + (double)this.avgDirtDepth + rand.nextDouble() * 0.25));
        int seaFloorDepth = 1 + rand.nextInt(2);
        int localX = x & 0xF;
        int localZ = z & 0xF;
        for (int y = 255; y >= 0; --y) {
            IBlockState state = primer.func_177856_a(localZ, y, localX);
            if (y <= rand.nextInt(5)) {
                primer.func_177855_a(localZ, y, localX, Blocks.field_150357_h.func_176223_P());
                continue;
            }
            if (state.func_185904_a() == Material.field_151579_a) {
                topBlocksToFill = topBlock == null ? 0 : 1;
                dirtBlocksToFill = dirtDepth;
                continue;
            }
            if (!hitFloorYet && state.func_185904_a() == Material.field_151586_h) {
                seaFloorBlocksToFill = seaFloorDepth;
            }
            if (state.func_177230_c() != Blocks.field_150348_b) continue;
            hitFloorYet = true;
            if (topBlocksToFill > 0) {
                if (y >= 62) {
                    primer.func_177855_a(localZ, y, localX, topBlock);
                } else if (y >= 56 - dirtDepth) {
                    primer.func_177855_a(localZ, y, localX, fillerBlock);
                } else {
                    primer.func_177855_a(localZ, y, localX, Blocks.field_150351_n.func_176223_P());
                    dirtBlocksToFill = 0;
                }
                --topBlocksToFill;
                continue;
            }
            if (seaFloorBlocksToFill > 0) {
                primer.func_177855_a(localZ, y, localX, seaFloorBlock);
                --seaFloorBlocksToFill;
                continue;
            }
            if (dirtBlocksToFill <= 0) continue;
            primer.func_177855_a(localZ, y, localX, fillerBlock);
            if (--dirtBlocksToFill == 0 && fillerBlock.func_177230_c() == Blocks.field_150354_m) {
                dirtBlocksToFill = rand.nextInt(4) + Math.max(0, y - 63);
                IBlockState iBlockState = fillerBlock = fillerBlock.func_177229_b((IProperty)BlockSand.field_176504_a) == BlockSand.EnumType.RED_SAND ? Blocks.field_180395_cM.func_176223_P() : Blocks.field_150322_A.func_176223_P();
            }
            if (dirtBlocksToFill != 0 || fillerBlock.func_177230_c() != BOPBlocks.white_sand) continue;
            dirtBlocksToFill = rand.nextInt(4) + Math.max(0, y - 63);
            fillerBlock = BOPBlocks.white_sandstone.func_176223_P();
        }
    }

    @Override
    public ResourceLocation getBeachLocation() {
        return this.beachBiomeLocation;
    }

    public float func_185355_j() {
        return ((float)this.terrainSettings.avgHeight - 65.0f) / 17.0f;
    }

    public float func_185360_m() {
        return Math.abs((((float)this.terrainSettings.variationAbove - 7.0f) / 80.0f + ((float)this.terrainSettings.variationBelow - 4.0f) / 20.0f) / 2.0f);
    }
}

