/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.RedstoneMode;
import appeng.api.config.SchedulingMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AECableType;
import appeng.core.AELog;
import appeng.core.settings.TickRates;
import appeng.core.sync.GuiBridge;
import appeng.helpers.MultiCraftingTracker;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.helpers.MachineSource;
import appeng.parts.PartModel;
import appeng.parts.automation.PartSharedItemBus;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;

public class PartExportBus
extends PartSharedItemBus
implements ICraftingRequester {
    public static final ResourceLocation MODEL_BASE = new ResourceLocation("appliedenergistics2", "part/export_bus_base");
    @PartModels
    public static final IPartModel MODELS_OFF = new PartModel(MODEL_BASE, new ResourceLocation("appliedenergistics2", "part/export_bus_off"));
    @PartModels
    public static final IPartModel MODELS_ON = new PartModel(MODEL_BASE, new ResourceLocation("appliedenergistics2", "part/export_bus_on"));
    @PartModels
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(MODEL_BASE, new ResourceLocation("appliedenergistics2", "part/export_bus_has_channel"));
    private final MultiCraftingTracker craftingTracker = new MultiCraftingTracker(this, 9);
    private final IActionSource mySrc;
    private long itemToSend = 1L;
    private boolean didSomething = false;
    private int nextSlot = 0;

    public PartExportBus(ItemStack is) {
        super(is);
        this.getConfigManager().registerSetting(Settings.REDSTONE_CONTROLLED, RedstoneMode.IGNORE);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.getConfigManager().registerSetting(Settings.CRAFT_ONLY, YesNo.NO);
        this.getConfigManager().registerSetting(Settings.SCHEDULING_MODE, SchedulingMode.DEFAULT);
        this.mySrc = new MachineSource(this);
    }

    @Override
    public void readFromNBT(NBTTagCompound extra) {
        super.readFromNBT(extra);
        this.craftingTracker.readFromNBT(extra);
        this.nextSlot = extra.func_74762_e("nextSlot");
    }

    @Override
    public void writeToNBT(NBTTagCompound extra) {
        super.writeToNBT(extra);
        this.craftingTracker.writeToNBT(extra);
        extra.func_74768_a("nextSlot", this.nextSlot);
    }

    @Override
    protected TickRateModulation doBusWork() {
        if (!this.getProxy().isActive() || !this.canDoBusWork()) {
            return TickRateModulation.IDLE;
        }
        this.itemToSend = this.calculateItemsToSend();
        this.didSomething = false;
        try {
            int x;
            InventoryAdaptor destination = this.getHandler();
            IMEMonitor<IAEItemStack> inv = this.getProxy().getStorage().getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
            IEnergyGrid energy = this.getProxy().getEnergy();
            ICraftingGrid cg = this.getProxy().getCrafting();
            FuzzyMode fzMode = (FuzzyMode)this.getConfigManager().getSetting(Settings.FUZZY_MODE);
            SchedulingMode schedulingMode = (SchedulingMode)this.getConfigManager().getSetting(Settings.SCHEDULING_MODE);
            if (destination != null) {
                x = 0;
                for (x = 0; x < this.availableSlots() && this.itemToSend > 0L; ++x) {
                    int slotToExport = this.getStartingSlot(schedulingMode, x);
                    IAEItemStack ais = this.getConfig().getAEStackInSlot(slotToExport);
                    if (ais == null || this.itemToSend <= 0L || this.craftOnly()) {
                        if (!this.isCraftingEnabled()) continue;
                        this.didSomething = this.craftingTracker.handleCrafting(slotToExport, this.itemToSend, ais, destination, this.getTile().func_145831_w(), this.getProxy().getGrid(), cg, this.mySrc) || this.didSomething;
                        continue;
                    }
                    long before = this.itemToSend;
                    if (this.getInstalledUpgrades(Upgrades.FUZZY) > 0) {
                        for (IAEItemStack o : ImmutableList.copyOf(inv.getStorageList().findFuzzy(ais, fzMode))) {
                            this.pushItemIntoTarget(destination, energy, inv, o);
                            if (this.itemToSend > 0L) continue;
                            break;
                        }
                    } else {
                        this.pushItemIntoTarget(destination, energy, inv, ais);
                    }
                    if (this.itemToSend != before || !this.isCraftingEnabled()) continue;
                    this.didSomething = this.craftingTracker.handleCrafting(slotToExport, this.itemToSend, ais, destination, this.getTile().func_145831_w(), this.getProxy().getGrid(), cg, this.mySrc) || this.didSomething;
                }
            } else {
                return TickRateModulation.SLEEP;
            }
            this.updateSchedulingMode(schedulingMode, x);
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return this.didSomething ? TickRateModulation.FASTER : TickRateModulation.SLOWER;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(4.0, 4.0, 12.0, 12.0, 12.0, 14.0);
        bch.addBox(5.0, 5.0, 14.0, 11.0, 11.0, 15.0);
        bch.addBox(6.0, 6.0, 15.0, 10.0, 10.0, 16.0);
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 12.0);
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return 5.0f;
    }

    @Override
    public boolean onPartActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (Platform.isServer()) {
            Platform.openGUI(player, this.getHost().getTile(), this.getSide(), GuiBridge.GUI_BUS);
        }
        return true;
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.ExportBus.getMin(), TickRates.ExportBus.getMax(), this.isSleeping(), false);
    }

    @Override
    public RedstoneMode getRSMode() {
        return (RedstoneMode)this.getConfigManager().getSetting(Settings.REDSTONE_CONTROLLED);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        return this.doBusWork();
    }

    @Override
    public ImmutableSet<ICraftingLink> getRequestedJobs() {
        return this.craftingTracker.getRequestedJobs();
    }

    @Override
    public IAEItemStack injectCraftedItems(ICraftingLink link, IAEItemStack items, Actionable mode) {
        InventoryAdaptor d = this.getHandler();
        try {
            double power;
            IEnergyGrid energy;
            if (d != null && this.getProxy().isActive() && (energy = this.getProxy().getEnergy()).extractAEPower(power = (double)items.getStackSize(), mode, PowerMultiplier.CONFIG) > power - 0.01) {
                if (mode == Actionable.MODULATE) {
                    return AEItemStack.fromItemStack(d.addItems(items.createItemStack()));
                }
                return AEItemStack.fromItemStack(d.simulateAdd(items.createItemStack()));
            }
        }
        catch (GridAccessException e) {
            AELog.debug(e);
        }
        return items;
    }

    @Override
    public void jobStateChange(ICraftingLink link) {
        this.craftingTracker.jobStateChange(link);
    }

    @Override
    protected boolean isSleeping() {
        return this.getHandler() == null || super.isSleeping();
    }

    private boolean craftOnly() {
        return this.getConfigManager().getSetting(Settings.CRAFT_ONLY) == YesNo.YES;
    }

    private boolean isCraftingEnabled() {
        return this.getInstalledUpgrades(Upgrades.CRAFTING) > 0;
    }

    private void pushItemIntoTarget(InventoryAdaptor d, IEnergyGrid energy, IMEInventory<IAEItemStack> inv, IAEItemStack ais) {
        long canFit;
        ItemStack is = ais.createItemStack();
        is.func_190920_e((int)this.itemToSend);
        ItemStack o = d.simulateAdd(is);
        long l = canFit = o.func_190926_b() ? this.itemToSend : this.itemToSend - (long)o.func_190916_E();
        if (canFit > 0L) {
            ais = ais.copy();
            ais.setStackSize(canFit);
            IAEItemStack itemsToAdd = Platform.poweredExtraction(energy, inv, ais, this.mySrc);
            if (itemsToAdd != null) {
                this.itemToSend -= itemsToAdd.getStackSize();
                ItemStack failed = d.addItems(itemsToAdd.createItemStack());
                if (!failed.func_190926_b()) {
                    ais.setStackSize(failed.func_190916_E());
                    inv.injectItems(ais, Actionable.MODULATE, this.mySrc);
                } else {
                    this.didSomething = true;
                }
            }
        }
    }

    private int getStartingSlot(SchedulingMode schedulingMode, int x) {
        if (schedulingMode == SchedulingMode.RANDOM) {
            return Platform.getRandom().nextInt(this.availableSlots());
        }
        if (schedulingMode == SchedulingMode.ROUNDROBIN) {
            return (this.nextSlot + x) % this.availableSlots();
        }
        return x;
    }

    private void updateSchedulingMode(SchedulingMode schedulingMode, int x) {
        if (schedulingMode == SchedulingMode.ROUNDROBIN) {
            this.nextSlot = (this.nextSlot + x) % this.availableSlots();
        }
    }

    @Override
    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }
}

