/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features;

import appeng.api.definitions.IBlockDefinition;
import appeng.core.features.ItemDefinition;
import com.google.common.base.Preconditions;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class BlockDefinition
extends ItemDefinition
implements IBlockDefinition {
    private final Optional<Block> block;

    public BlockDefinition(String registryName, Block block, ItemBlock item) {
        super(registryName, (Item)item);
        this.block = Optional.ofNullable(block);
    }

    @Override
    public final Optional<Block> maybeBlock() {
        return this.block;
    }

    @Override
    public final Optional<ItemBlock> maybeItemBlock() {
        return this.block.map(ItemBlock::new);
    }

    @Override
    public final Optional<ItemStack> maybeStack(int stackSize) {
        Preconditions.checkArgument((stackSize > 0 ? 1 : 0) != 0);
        return this.block.map(b -> new ItemStack(b, stackSize));
    }

    @Override
    public final boolean isSameAs(IBlockAccess world, BlockPos pos) {
        return this.block.isPresent() && world.func_180495_p(pos).func_177230_c() == this.block.get();
    }
}

