/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.inventory;

import appeng.api.AEApi;
import appeng.api.storage.data.IAEItemStack;
import appeng.core.AELog;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import appeng.util.iterators.AEInvIterator;
import appeng.util.iterators.InvIterator;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;

public class AppEngInternalAEInventory
implements IInventory,
Iterable<ItemStack> {
    private final IAEAppEngInventory te;
    private final IAEItemStack[] inv;
    private final int size;
    private int maxStack;

    public AppEngInternalAEInventory(IAEAppEngInventory te, int s) {
        this.te = te;
        this.size = s;
        this.maxStack = 64;
        this.inv = new IAEItemStack[s];
    }

    public boolean func_191420_l() {
        for (int x = 0; x < this.size; ++x) {
            if (this.func_70301_a(x).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public void setMaxStackSize(int s) {
        this.maxStack = s;
    }

    public IAEItemStack getAEStackInSlot(int var1) {
        return this.inv[var1];
    }

    public void writeToNBT(NBTTagCompound data, String name) {
        NBTTagCompound c = new NBTTagCompound();
        this.writeToNBT(c);
        data.func_74782_a(name, (NBTBase)c);
    }

    private void writeToNBT(NBTTagCompound target) {
        for (int x = 0; x < this.size; ++x) {
            try {
                NBTTagCompound c = new NBTTagCompound();
                if (this.inv[x] != null) {
                    this.inv[x].writeToNBT(c);
                }
                target.func_74782_a("#" + x, (NBTBase)c);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void readFromNBT(NBTTagCompound data, String name) {
        NBTTagCompound c = data.func_74775_l(name);
        if (c != null) {
            this.readFromNBT(c);
        }
    }

    private void readFromNBT(NBTTagCompound target) {
        for (int x = 0; x < this.size; ++x) {
            try {
                NBTTagCompound c = target.func_74775_l("#" + x);
                if (c == null) continue;
                this.inv[x] = AEItemStack.loadItemStackFromNBT(c);
                continue;
            }
            catch (Exception e) {
                AELog.debug(e);
            }
        }
    }

    public int func_70302_i_() {
        return this.size;
    }

    public ItemStack func_70301_a(int var1) {
        if (this.inv[var1] == null) {
            return ItemStack.field_190927_a;
        }
        return this.inv[var1].getItemStack();
    }

    public ItemStack func_70298_a(int slot, int qty) {
        if (this.inv[slot] != null) {
            ItemStack split = this.func_70301_a(slot);
            ItemStack ns = ItemStack.field_190927_a;
            if (qty >= split.func_190916_E()) {
                ns = this.func_70301_a(slot);
                this.inv[slot] = null;
            } else {
                ns = split.func_77979_a(qty);
            }
            if (this.te != null && Platform.isServer()) {
                this.te.onChangeInventory(this, slot, InvOperation.decreaseStackSize, ns, ItemStack.field_190927_a);
            }
            return ns;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int var1) {
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int slot, ItemStack newItemStack) {
        ItemStack oldStack = this.func_70301_a(slot);
        this.inv[slot] = AEApi.instance().storage().createItemStack(newItemStack);
        if (this.te != null && Platform.isServer()) {
            ItemStack removed = oldStack;
            ItemStack added = newItemStack;
            if (!oldStack.func_190926_b() && !newItemStack.func_190926_b() && Platform.itemComparisons().isEqualItem(oldStack, newItemStack)) {
                if (oldStack.func_190916_E() > newItemStack.func_190916_E()) {
                    removed = removed.func_77946_l();
                    removed.func_190917_f(-newItemStack.func_190916_E());
                    added = ItemStack.field_190927_a;
                } else if (oldStack.func_190916_E() < newItemStack.func_190916_E()) {
                    added = added.func_77946_l();
                    added.func_190917_f(-oldStack.func_190916_E());
                    removed = ItemStack.field_190927_a;
                } else {
                    removed = added = ItemStack.field_190927_a;
                }
            }
            this.te.onChangeInventory(this, slot, InvOperation.setInventorySlotContents, removed, added);
        }
    }

    public String func_70005_c_() {
        return "appeng-internal";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return this.maxStack > 64 ? 64 : this.maxStack;
    }

    public void func_70296_d() {
        if (this.te != null && Platform.isServer()) {
            this.te.onChangeInventory(this, -1, InvOperation.markDirty, ItemStack.field_190927_a, ItemStack.field_190927_a);
        }
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return true;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    @Override
    public Iterator<ItemStack> iterator() {
        return new InvIterator(this);
    }

    public Iterator<IAEItemStack> getNewAEIterator() {
        return new AEInvIterator(this);
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int x = 0; x < this.size; ++x) {
            this.func_70299_a(x, ItemStack.field_190927_a);
        }
    }
}

