/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.crafting;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.definitions.ITileDefinition;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.implementations.tiles.ICraftingMachine;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IConfigManager;
import appeng.container.ContainerNull;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketAssemblerAnimation;
import appeng.items.misc.ItemEncodedPattern;
import appeng.me.GridAccessException;
import appeng.parts.automation.DefinitionUpgradeInventory;
import appeng.parts.automation.UpgradeInventory;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkInvTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public class TileMolecularAssembler
extends AENetworkInvTile
implements IUpgradeableHost,
IConfigManagerHost,
IGridTickable,
ICraftingMachine,
IPowerChannelState {
    private static final int[] SIDES = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    private final InventoryCrafting craftingInv;
    private final AppEngInternalInventory inv = new AppEngInternalInventory(this, 11);
    private final IConfigManager settings;
    private final UpgradeInventory upgrades;
    private boolean isPowered = false;
    private AEPartLocation pushDirection = AEPartLocation.INTERNAL;
    private ItemStack myPattern = ItemStack.field_190927_a;
    private ICraftingPatternDetails myPlan = null;
    private double progress = 0.0;
    private boolean isAwake = false;
    private boolean forcePlan = false;
    private boolean reboot = true;

    public TileMolecularAssembler() {
        ITileDefinition assembler = AEApi.instance().definitions().blocks().molecularAssembler();
        this.settings = new ConfigManager(this);
        this.settings.registerSetting(Settings.REDSTONE_CONTROLLED, RedstoneMode.IGNORE);
        this.inv.setMaxStackSize(1);
        this.getProxy().setIdlePowerUsage(0.0);
        this.upgrades = new DefinitionUpgradeInventory(assembler, this, this.getUpgradeSlots());
        this.craftingInv = new InventoryCrafting((Container)new ContainerNull(), 3, 3);
    }

    private int getUpgradeSlots() {
        return 5;
    }

    @Override
    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table, EnumFacing where) {
        if (this.myPattern.func_190926_b()) {
            int x;
            boolean isEmpty = true;
            for (x = 0; x < this.inv.func_70302_i_(); ++x) {
                isEmpty = this.inv.func_70301_a(x).func_190926_b() && isEmpty;
            }
            if (isEmpty && patternDetails.isCraftable()) {
                this.forcePlan = true;
                this.myPlan = patternDetails;
                this.pushDirection = AEPartLocation.fromFacing(where);
                for (x = 0; x < table.func_70302_i_(); ++x) {
                    this.inv.func_70299_a(x, table.func_70301_a(x));
                }
                this.updateSleepiness();
                this.func_70296_d();
                return true;
            }
        }
        return false;
    }

    private void updateSleepiness() {
        boolean wasEnabled = this.isAwake;
        boolean bl = this.isAwake = this.myPlan != null && this.hasMats() || this.canPush();
        if (wasEnabled != this.isAwake) {
            try {
                if (this.isAwake) {
                    this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
                } else {
                    this.getProxy().getTick().sleepDevice(this.getProxy().getNode());
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    private boolean canPush() {
        return !this.inv.func_70301_a(9).func_190926_b();
    }

    private boolean hasMats() {
        if (this.myPlan == null) {
            return false;
        }
        for (int x = 0; x < this.craftingInv.func_70302_i_(); ++x) {
            this.craftingInv.func_70299_a(x, this.inv.func_70301_a(x));
        }
        return !this.myPlan.getOutput(this.craftingInv, this.func_145831_w()).func_190926_b();
    }

    @Override
    public boolean acceptsPlans() {
        return this.inv.func_70301_a(10).func_190926_b();
    }

    @Override
    public int getInstalledUpgrades(Upgrades u) {
        return this.upgrades.getInstalledUpgrades(u);
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    public boolean readFromStream_TileMolecularAssembler(ByteBuf data) {
        boolean oldPower = this.isPowered;
        this.isPowered = data.readBoolean();
        return this.isPowered != oldPower;
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    public void writeToStream_TileMolecularAssembler(ByteBuf data) {
        data.writeBoolean(this.isPowered);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void writeToNBT_TileMolecularAssembler(NBTTagCompound data) {
        ItemStack pattern;
        if (this.forcePlan && this.myPlan != null && !(pattern = this.myPlan.getPattern()).func_190926_b()) {
            NBTTagCompound compound = new NBTTagCompound();
            pattern.func_77955_b(compound);
            data.func_74782_a("myPlan", (NBTBase)compound);
            data.func_74768_a("pushDirection", this.pushDirection.ordinal());
        }
        this.upgrades.writeToNBT(data, "upgrades");
        this.inv.writeToNBT(data, "inv");
        this.settings.writeToNBT(data);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBT_TileMolecularAssembler(NBTTagCompound data) {
        ItemStack myPat;
        if (data.func_74764_b("myPlan") && !(myPat = new ItemStack(data.func_74775_l("myPlan"))).func_190926_b() && myPat.func_77973_b() instanceof ItemEncodedPattern) {
            World w = this.func_145831_w();
            ItemEncodedPattern iep = (ItemEncodedPattern)myPat.func_77973_b();
            ICraftingPatternDetails ph = iep.getPatternForItem(myPat, w);
            if (ph != null && ph.isCraftable()) {
                this.forcePlan = true;
                this.myPlan = ph;
                this.pushDirection = AEPartLocation.fromOrdinal(data.func_74762_e("pushDirection"));
            }
        }
        this.upgrades.readFromNBT(data, "upgrades");
        this.inv.readFromNBT(data, "inv");
        this.settings.readFromNBT(data);
        this.recalculatePlan();
    }

    private void recalculatePlan() {
        this.reboot = true;
        if (this.forcePlan) {
            return;
        }
        ItemStack is = this.inv.func_70301_a(10);
        if (!is.func_190926_b() && is.func_77973_b() instanceof ItemEncodedPattern) {
            if (!Platform.itemComparisons().isEqualItem(is, this.myPattern)) {
                World w = this.func_145831_w();
                ItemEncodedPattern iep = (ItemEncodedPattern)is.func_77973_b();
                ICraftingPatternDetails ph = iep.getPatternForItem(is, w);
                if (ph != null && ph.isCraftable()) {
                    this.progress = 0.0;
                    this.myPattern = is;
                    this.myPlan = ph;
                }
            }
        } else {
            this.progress = 0.0;
            this.forcePlan = false;
            this.myPlan = null;
            this.myPattern = ItemStack.field_190927_a;
            this.pushDirection = AEPartLocation.INTERNAL;
        }
        this.updateSleepiness();
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.COVERED;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this);
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.settings;
    }

    @Override
    public IInventory getInventoryByName(String name) {
        if (name.equals("upgrades")) {
            return this.upgrades;
        }
        if (name.equals("mac")) {
            return this.inv;
        }
        return null;
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
    }

    @Override
    public IInventory getInternalInventory() {
        return this.inv;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        if (i >= 9) {
            return false;
        }
        if (this.hasPattern()) {
            return this.myPlan.isValidItemForSlot(i, itemstack, this.func_145831_w());
        }
        return false;
    }

    private boolean hasPattern() {
        return this.myPlan != null && !this.inv.func_70301_a(10).func_190926_b();
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (inv == this.inv) {
            this.recalculatePlan();
        }
    }

    @Override
    public boolean func_180461_b(int slotIndex, ItemStack extractedItem, EnumFacing side) {
        return slotIndex == 9;
    }

    @Override
    public int[] getAccessibleSlotsBySide(EnumFacing whichSide) {
        return SIDES;
    }

    public int getCraftingProgress() {
        return (int)this.progress;
    }

    @Override
    public void getDrops(World w, BlockPos pos, List<ItemStack> drops) {
        super.getDrops(w, pos, drops);
        for (int h = 0; h < this.upgrades.func_70302_i_(); ++h) {
            ItemStack is = this.upgrades.func_70301_a(h);
            if (is.func_190926_b()) continue;
            drops.add(is);
        }
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        this.recalculatePlan();
        this.updateSleepiness();
        return new TickingRequest(1, 1, !this.isAwake, false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (!this.inv.func_70301_a(9).func_190926_b()) {
            this.pushOut(this.inv.func_70301_a(9));
            if (this.inv.func_70301_a(9).func_190926_b()) {
                this.func_70296_d();
            }
            this.ejectHeldItems();
            this.updateSleepiness();
            this.progress = 0.0;
            return this.isAwake ? TickRateModulation.IDLE : TickRateModulation.SLEEP;
        }
        if (this.myPlan == null) {
            this.updateSleepiness();
            return TickRateModulation.SLEEP;
        }
        if (this.reboot) {
            ticksSinceLastCall = 1;
        }
        if (!this.isAwake) {
            return TickRateModulation.SLEEP;
        }
        this.reboot = false;
        int speed = 10;
        switch (this.upgrades.getInstalledUpgrades(Upgrades.SPEED)) {
            case 0: {
                speed = 10;
                this.progress += (double)this.userPower(ticksSinceLastCall, 10, 1.0);
                break;
            }
            case 1: {
                speed = 13;
                this.progress += (double)this.userPower(ticksSinceLastCall, 13, 1.3);
                break;
            }
            case 2: {
                speed = 17;
                this.progress += (double)this.userPower(ticksSinceLastCall, 17, 1.7);
                break;
            }
            case 3: {
                speed = 20;
                this.progress += (double)this.userPower(ticksSinceLastCall, 20, 2.0);
                break;
            }
            case 4: {
                speed = 25;
                this.progress += (double)this.userPower(ticksSinceLastCall, 25, 2.5);
                break;
            }
            case 5: {
                speed = 50;
                this.progress += (double)this.userPower(ticksSinceLastCall, 50, 5.0);
            }
        }
        if (this.progress >= 100.0) {
            for (int x = 0; x < this.craftingInv.func_70302_i_(); ++x) {
                this.craftingInv.func_70299_a(x, this.inv.func_70301_a(x));
            }
            this.progress = 0.0;
            ItemStack output = this.myPlan.getOutput(this.craftingInv, this.func_145831_w());
            if (!output.func_190926_b()) {
                FMLCommonHandler.instance().firePlayerCraftingEvent(Platform.getPlayer((WorldServer)this.func_145831_w()), output, (IInventory)this.craftingInv);
                this.pushOut(output.func_77946_l());
                for (int x = 0; x < this.craftingInv.func_70302_i_(); ++x) {
                    this.inv.func_70299_a(x, Platform.getContainerItem(this.craftingInv.func_70301_a(x)));
                }
                if (this.inv.func_70301_a(10).func_190926_b()) {
                    this.forcePlan = false;
                    this.myPlan = null;
                    this.pushDirection = AEPartLocation.INTERNAL;
                }
                this.ejectHeldItems();
                try {
                    NetworkRegistry.TargetPoint where = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 32.0);
                    AEItemStack item = AEItemStack.create(output);
                    NetworkHandler.instance().sendToAllAround(new PacketAssemblerAnimation(this.field_174879_c, (byte)speed, item), where);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.func_70296_d();
                this.updateSleepiness();
                return this.isAwake ? TickRateModulation.IDLE : TickRateModulation.SLEEP;
            }
        }
        return TickRateModulation.FASTER;
    }

    private void ejectHeldItems() {
        if (this.inv.func_70301_a(9).func_190926_b()) {
            for (int x = 0; x < 9; ++x) {
                ItemStack is = this.inv.func_70301_a(x);
                if (is.func_190926_b() || this.myPlan != null && this.myPlan.isValidItemForSlot(x, is, this.field_145850_b)) continue;
                this.inv.func_70299_a(9, is);
                this.inv.func_70299_a(x, ItemStack.field_190927_a);
                this.func_70296_d();
                return;
            }
        }
    }

    private int userPower(int ticksPassed, int bonusValue, double acceleratorTax) {
        try {
            return (int)(this.getProxy().getEnergy().extractAEPower((double)(ticksPassed * bonusValue) * acceleratorTax, Actionable.MODULATE, PowerMultiplier.CONFIG) / acceleratorTax);
        }
        catch (GridAccessException e) {
            return 0;
        }
    }

    private void pushOut(ItemStack output) {
        if (this.pushDirection == AEPartLocation.INTERNAL) {
            for (EnumFacing d : EnumFacing.field_82609_l) {
                output = this.pushTo(output, d);
            }
        } else {
            output = this.pushTo(output, this.pushDirection.getFacing());
        }
        if (output.func_190926_b() && this.forcePlan) {
            this.forcePlan = false;
            this.recalculatePlan();
        }
        this.inv.func_70299_a(9, output);
    }

    private ItemStack pushTo(ItemStack output, EnumFacing d) {
        int newSize;
        if (output.func_190926_b()) {
            return output;
        }
        TileEntity te = this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(d));
        if (te == null) {
            return output;
        }
        InventoryAdaptor adaptor = InventoryAdaptor.getAdaptor(te, d.func_176734_d());
        if (adaptor == null) {
            return output;
        }
        int size = output.func_190916_E();
        int n = newSize = (output = adaptor.addItems(output)).func_190926_b() ? 0 : output.func_190916_E();
        if (size != newSize) {
            this.func_70296_d();
        }
        return output;
    }

    @MENetworkEventSubscribe
    public void onPowerEvent(MENetworkPowerStatusChange p) {
        this.updatePowerState();
    }

    private void updatePowerState() {
        boolean newState = false;
        try {
            newState = this.getProxy().isActive() && this.getProxy().getEnergy().extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 1.0E-4;
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        if (newState != this.isPowered) {
            this.isPowered = newState;
            this.markForUpdate();
        }
    }

    @Override
    public boolean isPowered() {
        return this.isPowered;
    }

    @Override
    public boolean isActive() {
        return this.isPowered;
    }

    public boolean func_191420_l() {
        return false;
    }
}

