/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile;

import appeng.block.AEBaseBlock;
import appeng.tile.AEBaseTile;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import java.util.EnumMap;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public abstract class AEBaseInvTile
extends AEBaseTile
implements ISidedInventory,
IAEAppEngInventory {
    private EnumMap<EnumFacing, IItemHandler> sidedItemHandler = new EnumMap(EnumFacing.class);
    private IItemHandler itemHandler;

    public String func_70005_c_() {
        return this.getCustomName();
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBT_AEBaseInvTile(NBTTagCompound data) {
        IInventory inv = this.getInternalInventory();
        NBTTagCompound opt = data.func_74775_l("inv");
        for (int x = 0; x < inv.func_70302_i_(); ++x) {
            NBTTagCompound item = opt.func_74775_l("item" + x);
            inv.func_70299_a(x, new ItemStack(item));
        }
    }

    public abstract IInventory getInternalInventory();

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void writeToNBT_AEBaseInvTile(NBTTagCompound data) {
        IInventory inv = this.getInternalInventory();
        NBTTagCompound opt = new NBTTagCompound();
        for (int x = 0; x < inv.func_70302_i_(); ++x) {
            NBTTagCompound item = new NBTTagCompound();
            ItemStack is = this.func_70301_a(x);
            if (!is.func_190926_b()) {
                is.func_77955_b(item);
            }
            opt.func_74782_a("item" + x, (NBTBase)item);
        }
        data.func_74782_a("inv", (NBTBase)opt);
    }

    public int func_70302_i_() {
        return this.getInternalInventory().func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.getInternalInventory().func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.getInternalInventory().func_70298_a(i, j);
    }

    public ItemStack func_70304_b(int i) {
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int i, @Nullable ItemStack itemstack) {
        this.getInternalInventory().func_70299_a(i, itemstack);
    }

    public boolean func_145818_k_() {
        return this.getInternalInventory().func_145818_k_();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer p) {
        double squaredMCReach = 64.0;
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && p.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    @Override
    public abstract void onChangeInventory(IInventory var1, int var2, InvOperation var3, ItemStack var4, ItemStack var5);

    public int[] func_180463_a(EnumFacing side) {
        Block blk = this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
        if (blk instanceof AEBaseBlock) {
            return this.getAccessibleSlotsBySide(((AEBaseBlock)blk).mapRotation(this, side));
        }
        return this.getAccessibleSlotsBySide(side);
    }

    public boolean func_180462_a(int slotIndex, ItemStack insertingItem, EnumFacing side) {
        return this.func_94041_b(slotIndex, insertingItem);
    }

    public boolean func_180461_b(int slotIndex, ItemStack extractedItem, EnumFacing side) {
        return true;
    }

    public void func_174888_l() {
        this.getInternalInventory().func_174888_l();
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public ITextComponent func_145748_c_() {
        if (this.func_145818_k_()) {
            return new TextComponentString(this.getCustomName());
        }
        return new TextComponentTranslation(this.func_145838_q().func_149739_a(), new Object[0]);
    }

    public abstract int[] getAccessibleSlotsBySide(EnumFacing var1);

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                if (this.itemHandler == null) {
                    this.itemHandler = new InvWrapper(this.getInternalInventory());
                }
                return (T)this.itemHandler;
            }
            return (T)this.sidedItemHandler.computeIfAbsent(facing, side -> new SidedInvWrapper((ISidedInventory)this, side));
        }
        return (T)super.getCapability(capability, facing);
    }
}

