/*
 * Decompiled with CFR 0.152.
 */
package appeng.spatial;

import appeng.api.AEApi;
import appeng.api.util.WorldCoord;
import appeng.core.stats.Achievements;
import appeng.spatial.CachedPlane;
import appeng.spatial.ISpatialVisitor;
import appeng.spatial.StorageWorldProvider;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class StorageHelper {
    private static StorageHelper instance;

    public static StorageHelper getInstance() {
        if (instance == null) {
            instance = new StorageHelper();
        }
        return instance;
    }

    private Entity teleportEntity(Entity entity, TelDestination link) {
        EntityPlayerMP player;
        WorldServer newWorld;
        WorldServer oldWorld;
        try {
            oldWorld = (WorldServer)entity.field_70170_p;
            newWorld = (WorldServer)link.dim;
            player = entity instanceof EntityPlayerMP ? (EntityPlayerMP)entity : null;
        }
        catch (Throwable e) {
            return entity;
        }
        if (oldWorld == null) {
            return entity;
        }
        if (newWorld == null) {
            return entity;
        }
        if (entity.func_184218_aH()) {
            return this.teleportEntity(entity.func_184187_bx(), link);
        }
        List passangers = entity.func_184188_bt();
        ArrayList<Entity> passangersOnOtherSide = new ArrayList<Entity>();
        if (!passangers.isEmpty()) {
            for (Entity passanger : passangers) {
                passanger.func_184210_p();
                passangersOnOtherSide.add(this.teleportEntity(passanger, link));
            }
        }
        newWorld.func_72863_F().func_186025_d(MathHelper.func_76128_c((double)link.x) >> 4, MathHelper.func_76128_c((double)link.z) >> 4);
        if (newWorld != oldWorld) {
            if (player != null) {
                if (((TelDestination)link).dim.field_73011_w instanceof StorageWorldProvider) {
                    Achievements.SpatialIOExplorer.addToPlayer((EntityPlayer)player);
                }
                player.field_71133_b.func_184103_al().transferPlayerToDimension(player, ((TelDestination)link).dim.field_73011_w.getDimension(), (Teleporter)new METeleporter(newWorld, link));
            } else {
                entity.func_184102_h().func_184103_al().transferEntityToWorld(entity, entity.field_71093_bK, entity.func_184102_h().func_71218_a(entity.field_71093_bK), (WorldServer)link.dim, (Teleporter)new METeleporter(newWorld, link));
            }
        }
        if (!passangersOnOtherSide.isEmpty()) {
            if (player != null) {
                entity.field_70170_p.func_72866_a(entity, true);
            }
            for (Entity passanger : passangersOnOtherSide) {
                passanger.func_184205_a(entity, true);
            }
        }
        return entity;
    }

    private void transverseEdges(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, ISpatialVisitor visitor) {
        int x;
        int z;
        for (int y = minY; y < maxY; ++y) {
            for (z = minZ; z < maxZ; ++z) {
                visitor.visit(new BlockPos(minX, y, z));
                visitor.visit(new BlockPos(maxX, y, z));
            }
        }
        for (x = minX; x < maxX; ++x) {
            for (z = minZ; z < maxZ; ++z) {
                visitor.visit(new BlockPos(x, minY, z));
                visitor.visit(new BlockPos(x, maxY, z));
            }
        }
        for (x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                visitor.visit(new BlockPos(x, y, minZ));
                visitor.visit(new BlockPos(x, y, maxZ));
            }
        }
    }

    public void swapRegions(World srcWorld, int srcX, int srcY, int srcZ, World dstWorld, int dstX, int dstY, int dstZ, int scaleX, int scaleY, int scaleZ) {
        AEApi.instance().definitions().blocks().matrixFrame().maybeBlock().ifPresent(matrixFrameBlock -> this.transverseEdges(dstX - 1, dstY - 1, dstZ - 1, dstX + scaleX + 1, dstY + scaleY + 1, dstZ + scaleZ + 1, new WrapInMatrixFrame(matrixFrameBlock.func_176223_P(), dstWorld)));
        AxisAlignedBB srcBox = new AxisAlignedBB((double)srcX, (double)srcY, (double)srcZ, (double)(srcX + scaleX + 1), (double)(srcY + scaleY + 1), (double)(srcZ + scaleZ + 1));
        AxisAlignedBB dstBox = new AxisAlignedBB((double)dstX, (double)dstY, (double)dstZ, (double)(dstX + scaleX + 1), (double)(dstY + scaleY + 1), (double)(dstZ + scaleZ + 1));
        CachedPlane cDst = new CachedPlane(dstWorld, dstX, dstY, dstZ, dstX + scaleX, dstY + scaleY, dstZ + scaleZ);
        CachedPlane cSrc = new CachedPlane(srcWorld, srcX, srcY, srcZ, srcX + scaleX, srcY + scaleY, srcZ + scaleZ);
        cSrc.swap(cDst);
        List srcE = srcWorld.func_72872_a(Entity.class, srcBox);
        List dstE = dstWorld.func_72872_a(Entity.class, dstBox);
        for (Entity e : dstE) {
            this.teleportEntity(e, new TelDestination(srcWorld, srcBox, e.field_70165_t, e.field_70163_u, e.field_70161_v, -dstX + srcX, -dstY + srcY, -dstZ + srcZ));
        }
        for (Entity e : srcE) {
            this.teleportEntity(e, new TelDestination(dstWorld, dstBox, e.field_70165_t, e.field_70163_u, e.field_70161_v, -srcX + dstX, -srcY + dstY, -srcZ + dstZ));
        }
        for (WorldCoord wc : cDst.getUpdates()) {
            cSrc.getWorld().func_175685_c(wc.getPos(), Platform.AIR_BLOCK, true);
        }
        for (WorldCoord wc : cSrc.getUpdates()) {
            cSrc.getWorld().func_175685_c(wc.getPos(), Platform.AIR_BLOCK, true);
        }
        this.transverseEdges(srcX - 1, srcY - 1, srcZ - 1, srcX + scaleX + 1, srcY + scaleY + 1, srcZ + scaleZ + 1, new TriggerUpdates(srcWorld));
        this.transverseEdges(dstX - 1, dstY - 1, dstZ - 1, dstX + scaleX + 1, dstY + scaleY + 1, dstZ + scaleZ + 1, new TriggerUpdates(dstWorld));
        this.transverseEdges(srcX, srcY, srcZ, srcX + scaleX, srcY + scaleY, srcZ + scaleZ, new TriggerUpdates(srcWorld));
        this.transverseEdges(dstX, dstY, dstZ, dstX + scaleX, dstY + scaleY, dstZ + scaleZ, new TriggerUpdates(dstWorld));
    }

    private static class METeleporter
    extends Teleporter {
        private final TelDestination destination;

        public METeleporter(WorldServer par1WorldServer, TelDestination d) {
            super(par1WorldServer);
            this.destination = d;
        }

        public void func_180266_a(Entity par1Entity, float rotationYaw) {
            par1Entity.func_70012_b(this.destination.x, this.destination.y, this.destination.z, par1Entity.field_70177_z, 0.0f);
            par1Entity.field_70179_y = 0.0;
            par1Entity.field_70181_x = 0.0;
            par1Entity.field_70159_w = 0.0;
        }

        public boolean func_180620_b(Entity entityIn, float p_180620_2_) {
            return false;
        }

        public boolean func_85188_a(Entity par1Entity) {
            return false;
        }

        public void func_85189_a(long par1) {
        }
    }

    private static class TelDestination {
        private final World dim;
        private final double x;
        private final double y;
        private final double z;
        private final int xOff;
        private final int yOff;
        private final int zOff;

        TelDestination(World dimension, AxisAlignedBB srcBox, double x, double y, double z, int tileX, int tileY, int tileZ) {
            this.dim = dimension;
            this.x = Math.min(srcBox.field_72336_d - 0.5, Math.max(srcBox.field_72340_a + 0.5, x + (double)tileX));
            this.y = Math.min(srcBox.field_72337_e - 0.5, Math.max(srcBox.field_72338_b + 0.5, y + (double)tileY));
            this.z = Math.min(srcBox.field_72334_f - 0.5, Math.max(srcBox.field_72339_c + 0.5, z + (double)tileZ));
            this.xOff = tileX;
            this.yOff = tileY;
            this.zOff = tileZ;
        }
    }

    private static class WrapInMatrixFrame
    implements ISpatialVisitor {
        private final World dst;
        private final IBlockState state;

        public WrapInMatrixFrame(IBlockState state, World dst2) {
            this.dst = dst2;
            this.state = state;
        }

        @Override
        public void visit(BlockPos pos) {
            this.dst.func_175656_a(pos, this.state);
        }
    }

    private static class TriggerUpdates
    implements ISpatialVisitor {
        private final World dst;

        public TriggerUpdates(World dst2) {
            this.dst = dst2;
        }

        @Override
        public void visit(BlockPos pos) {
            Block blk = this.dst.func_180495_p(pos).func_177230_c();
            blk.func_189540_a(Platform.AIR_BLOCK.func_176223_P(), this.dst, pos, Platform.AIR_BLOCK, pos);
        }
    }
}

