/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes;

import appeng.api.exceptions.MissingIngredientError;
import appeng.api.exceptions.RecipeError;
import appeng.api.exceptions.RegistrationError;
import appeng.api.recipes.IIngredient;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class GroupIngredient
implements IIngredient {
    private final String name;
    private final List<IIngredient> ingredients;
    private final int qty;
    private ItemStack[] baked;
    private boolean isInside = false;

    public GroupIngredient(String myName, List<IIngredient> ingredients, int qty) throws RecipeError {
        Preconditions.checkNotNull((Object)myName);
        Preconditions.checkNotNull(ingredients);
        Preconditions.checkState((!ingredients.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkState((qty > 0 ? 1 : 0) != 0);
        this.name = myName;
        this.qty = qty;
        for (IIngredient ingredient : ingredients) {
            if (!ingredient.isAir()) continue;
            throw new RecipeError("Cannot include air in a group.");
        }
        this.ingredients = ingredients;
    }

    IIngredient copy(int qty) throws RecipeError {
        Preconditions.checkState((qty > 0 ? 1 : 0) != 0);
        return new GroupIngredient(this.name, this.ingredients, qty);
    }

    @Override
    public ItemStack getItemStack() throws RegistrationError, MissingIngredientError {
        throw new RegistrationError("Cannot pass group of items to a recipe which desires a single recipe item.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemStack[] getItemStackSet() throws RegistrationError, MissingIngredientError {
        if (this.baked != null) {
            return this.baked;
        }
        if (this.isInside) {
            return new ItemStack[0];
        }
        LinkedList<ItemStack> out = new LinkedList<ItemStack>();
        this.isInside = true;
        try {
            for (IIngredient i : this.ingredients) {
                try {
                    out.addAll(Arrays.asList(i.getItemStackSet()));
                }
                catch (MissingIngredientError missingIngredientError) {}
            }
        }
        finally {
            this.isInside = false;
        }
        if (out.isEmpty()) {
            throw new MissingIngredientError(this.toString() + " - group could not be resolved to any items.");
        }
        for (ItemStack is : out) {
            is.func_190920_e(this.qty);
        }
        return out.toArray(new ItemStack[out.size()]);
    }

    @Override
    public boolean isAir() {
        return false;
    }

    @Override
    public String getNameSpace() {
        return "";
    }

    @Override
    public String getItemName() {
        return this.name;
    }

    @Override
    public int getDamageValue() {
        return Short.MAX_VALUE;
    }

    @Override
    public int getQty() {
        return this.qty;
    }

    @Override
    public void bake() throws RegistrationError, MissingIngredientError {
        this.baked = null;
        this.baked = this.getItemStackSet();
    }
}

