/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.networking.events.MENetworkBootingStatusChange;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.parts.IPartModel;
import appeng.core.AELog;
import appeng.coremod.annotations.Integration;
import appeng.integration.IntegrationRegistry;
import appeng.integration.IntegrationType;
import appeng.items.parts.PartModels;
import appeng.parts.p2p.P2PModels;
import appeng.parts.p2p.PartP2PTunnel;
import java.util.List;
import javax.annotation.Nullable;
import li.cil.oc.api.API;
import li.cil.oc.api.Network;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.SidedEnvironment;
import li.cil.oc.api.network.Visibility;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

@Integration.InterfaceList(value={@Integration.Interface(iface="li.cil.oc.api.network.Environment", iname=IntegrationType.OpenComputers), @Integration.Interface(iface="li.cil.oc.api.network.SidedEnvironment", iname=IntegrationType.OpenComputers)})
public final class PartP2POpenComputers
extends PartP2PTunnel<PartP2POpenComputers>
implements Environment,
SidedEnvironment {
    @Nullable
    private final Node node;
    private static final P2PModels MODELS = new P2PModels("part/p2p/p2p_tunnel_opencomputers");

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public PartP2POpenComputers(ItemStack is) {
        super(is);
        if (!IntegrationRegistry.INSTANCE.isEnabled(IntegrationType.OpenComputers)) {
            AELog.error("OpenComputers tunnel part created when integration is disabled. Did you disable it but not remove parts?", new Object[0]);
        }
        this.node = API.network != null ? Network.newNode((Environment)this, (Visibility)Visibility.None).create() : null;
    }

    @MENetworkEventSubscribe
    public void changeStateA(MENetworkBootingStatusChange bs) {
        this.updateConnections();
    }

    @MENetworkEventSubscribe
    public void changeStateB(MENetworkChannelsChanged bs) {
        this.updateConnections();
    }

    @MENetworkEventSubscribe
    public void changeStateC(MENetworkPowerStatusChange bs) {
        this.updateConnections();
    }

    @Override
    public void removeFromWorld() {
        super.removeFromWorld();
        if (this.node != null) {
            this.node.remove();
        }
    }

    @Override
    public void onTunnelNetworkChange() {
        this.updateConnections();
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (this.node != null) {
            this.node.load(data);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        if (this.node != null) {
            this.node.save(data);
        }
    }

    private void updateConnections() {
        if (this.getProxy().isPowered() && this.getProxy().isActive()) {
            Network.joinOrCreateNetwork((TileEntity)this.getTile());
            if (this.isOutput() && this.getInput() != null && this.node != null) {
                Network.joinOrCreateNetwork((TileEntity)((PartP2POpenComputers)this.getInput()).getTile());
                this.node.connect(((PartP2POpenComputers)this.getInput()).node());
            }
        } else if (this.node != null) {
            this.node.remove();
        }
    }

    @Nullable
    public Node node() {
        return this.node;
    }

    public void onConnect(Node node) {
    }

    public void onDisconnect(Node node) {
    }

    public void onMessage(Message message) {
    }

    @Nullable
    public Node sidedNode(EnumFacing side) {
        return side == this.getSide().getFacing() ? this.node : null;
    }

    public boolean canConnect(EnumFacing side) {
        return side == this.getSide().getFacing();
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }
}

