/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.config.PowerUnits;
import appeng.api.parts.IPartModel;
import appeng.coremod.annotations.Integration;
import appeng.integration.IntegrationType;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.cache.helpers.TunnelCollection;
import appeng.parts.p2p.P2PModels;
import appeng.parts.p2p.PartP2PTunnel;
import appeng.util.Platform;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

@Integration.InterfaceList(value={@Integration.Interface(iface="ic2.api.energy.tile.IEnergySink", iname=IntegrationType.IC2), @Integration.Interface(iface="ic2.api.energy.tile.IEnergySource", iname=IntegrationType.IC2)})
public class PartP2PIC2Power
extends PartP2PTunnel<PartP2PIC2Power>
implements IEnergySink {
    private static final String TAG_BUFFERED_ENERGY_1 = "bufferedEnergy1";
    private static final String TAG_BUFFERED_ENERGY_2 = "bufferedEnergy2";
    private static final String TAG_BUFFERED_VOLTAGE_1 = "outputPacket1";
    private static final String TAG_BUFFERED_VOLTAGE_2 = "outputPacket2";
    private static final P2PModels MODELS = new P2PModels("part/p2p/p2p_tunnel_ic2");
    private double bufferedEnergy1;
    private double bufferedVoltage1;
    private double bufferedEnergy2;
    private double bufferedVoltage2;

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public PartP2PIC2Power(ItemStack is) {
        super(is);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.bufferedEnergy1 = tag.func_74769_h(TAG_BUFFERED_ENERGY_1);
        this.bufferedEnergy2 = tag.func_74769_h(TAG_BUFFERED_ENERGY_2);
        this.bufferedVoltage1 = tag.func_74769_h(TAG_BUFFERED_VOLTAGE_1);
        this.bufferedVoltage2 = tag.func_74769_h(TAG_BUFFERED_VOLTAGE_2);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74780_a(TAG_BUFFERED_ENERGY_1, this.bufferedEnergy1);
        tag.func_74780_a(TAG_BUFFERED_ENERGY_2, this.bufferedEnergy2);
        tag.func_74780_a(TAG_BUFFERED_VOLTAGE_1, this.bufferedVoltage1);
        tag.func_74780_a(TAG_BUFFERED_VOLTAGE_2, this.bufferedVoltage2);
    }

    @Override
    public void onTunnelConfigChange() {
        this.getHost().partChanged();
    }

    @Override
    public void onTunnelNetworkChange() {
        this.getHost().notifyNeighbors();
    }

    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing direction) {
        return !this.isOutput() && direction == this.getSide().getFacing();
    }

    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing direction) {
        return this.isOutput() && direction == this.getSide().getFacing();
    }

    public double getDemandedEnergy() {
        if (this.isOutput()) {
            return 0.0;
        }
        try {
            for (PartP2PIC2Power t : this.getOutputs()) {
                if (!(t.bufferedEnergy1 <= 1.0E-4) && !(t.bufferedEnergy2 <= 1.0E-4)) continue;
                return 2048.0;
            }
        }
        catch (GridAccessException e) {
            return 0.0;
        }
        return 0.0;
    }

    public int getSinkTier() {
        return 4;
    }

    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        TunnelCollection outs;
        try {
            outs = this.getOutputs();
        }
        catch (GridAccessException e) {
            return amount;
        }
        if (outs.isEmpty()) {
            return amount;
        }
        LinkedList<PartP2PIC2Power> options = new LinkedList<PartP2PIC2Power>();
        for (PartP2PIC2Power o : outs) {
            if (!(o.bufferedEnergy1 <= 0.01)) continue;
            options.add(o);
        }
        if (options.isEmpty()) {
            for (PartP2PIC2Power o : outs) {
                if (!(o.bufferedEnergy2 <= 0.01)) continue;
                options.add(o);
            }
        }
        if (options.isEmpty()) {
            for (PartP2PIC2Power o : outs) {
                options.add(o);
            }
        }
        if (options.isEmpty()) {
            return amount;
        }
        PartP2PIC2Power x = (PartP2PIC2Power)Platform.pickRandom(options);
        if (x != null && x.bufferedEnergy1 <= 0.001) {
            this.queueTunnelDrain(PowerUnits.EU, amount);
            x.bufferedEnergy1 = amount;
            x.bufferedVoltage1 = voltage;
            return 0.0;
        }
        if (x != null && x.bufferedEnergy2 <= 0.001) {
            this.queueTunnelDrain(PowerUnits.EU, amount);
            x.bufferedEnergy2 = amount;
            x.bufferedVoltage2 = voltage;
            return 0.0;
        }
        return amount;
    }

    public double getOfferedEnergy() {
        if (this.isOutput()) {
            return this.bufferedEnergy1;
        }
        return 0.0;
    }

    public void drawEnergy(double amount) {
        this.bufferedEnergy1 -= amount;
        if (this.bufferedEnergy1 < 0.001) {
            this.bufferedEnergy1 = this.bufferedEnergy2;
            this.bufferedEnergy2 = 0.0;
            this.bufferedVoltage1 = this.bufferedVoltage2;
            this.bufferedVoltage2 = 0.0;
        }
    }

    public int getSourceTier() {
        return 4;
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }
}

