/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.networking;

import appeng.api.AEApi;
import appeng.api.config.SecurityPermissions;
import appeng.api.definitions.IParts;
import appeng.api.implementations.parts.IPartCable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.parts.BusSupport;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.AEPartLocation;
import appeng.api.util.IReadOnlyCollection;
import appeng.items.parts.ItemPart;
import appeng.me.GridAccessException;
import appeng.parts.AEBasePart;
import appeng.util.Platform;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.AbstractSet;
import java.util.EnumSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class PartCable
extends AEBasePart
implements IPartCable {
    private static final ImmutableSet<AEPartLocation> STRAIGHT_PART_LOCATIONS = ImmutableSet.of((Object)((Object)AEPartLocation.DOWN), (Object)((Object)AEPartLocation.NORTH), (Object)((Object)AEPartLocation.EAST));
    private final int[] channelsOnSide = new int[]{0, 0, 0, 0, 0, 0};
    private EnumSet<AEPartLocation> connections = EnumSet.noneOf(AEPartLocation.class);
    private boolean powered = false;

    public PartCable(ItemStack is) {
        super(is);
        this.getProxy().setFlags(GridFlags.PREFERRED);
        this.getProxy().setIdlePowerUsage(0.0);
        this.getProxy().setColor(AEColor.values()[((ItemPart)is.func_77973_b()).variantOf(is.func_77952_i())]);
    }

    @Override
    public BusSupport supportsBuses() {
        return BusSupport.CABLE;
    }

    @Override
    public AEColor getCableColor() {
        return this.getProxy().getColor();
    }

    @Override
    public AECableType getCableConnectionType() {
        return AECableType.GLASS;
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        if (cable == this.getCableConnectionType()) {
            return 4.0f;
        }
        if (cable.ordinal() >= this.getCableConnectionType().ordinal()) {
            return -1.0f;
        }
        return 8.0f;
    }

    @Override
    public boolean changeColor(AEColor newColor, EntityPlayer who) {
        if (this.getCableColor() != newColor) {
            ItemStack newPart = ItemStack.field_190927_a;
            IParts parts = AEApi.instance().definitions().parts();
            if (this.getCableConnectionType() == AECableType.GLASS) {
                newPart = parts.cableGlass().stack(newColor, 1);
            } else if (this.getCableConnectionType() == AECableType.COVERED) {
                newPart = parts.cableCovered().stack(newColor, 1);
            } else if (this.getCableConnectionType() == AECableType.SMART) {
                newPart = parts.cableSmart().stack(newColor, 1);
            } else if (this.getCableConnectionType() == AECableType.DENSE) {
                newPart = parts.cableDense().stack(newColor, 1);
            }
            boolean hasPermission = true;
            try {
                hasPermission = this.getProxy().getSecurity().hasPermission(who, SecurityPermissions.BUILD);
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            if (!newPart.func_190926_b() && hasPermission) {
                if (Platform.isClient()) {
                    return true;
                }
                this.getHost().removePart(AEPartLocation.INTERNAL, true);
                this.getHost().addPart(newPart, AEPartLocation.INTERNAL, who, null);
                return true;
            }
        }
        return false;
    }

    @Override
    public void setValidSides(EnumSet<EnumFacing> sides) {
        this.getProxy().setValidSides(sides);
    }

    @Override
    public boolean isConnected(EnumFacing side) {
        return this.getConnections().contains((Object)AEPartLocation.fromFacing(side));
    }

    public void markForUpdate() {
        this.getHost().markForUpdate();
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        IPartHost ph;
        bch.addBox(6.0, 6.0, 6.0, 10.0, 10.0, 10.0);
        if (Platform.isServer()) {
            IGridNode n = this.getGridNode();
            if (n != null) {
                this.setConnections(n.getConnectedSides());
            } else {
                this.getConnections().clear();
            }
        }
        if ((ph = this.getHost()) != null) {
            block16: for (AEPartLocation dir : AEPartLocation.SIDE_LOCATIONS) {
                double dist;
                IPart p = ph.getPart(dir);
                if (!(p instanceof IGridHost) || (dist = (double)p.getCableConnectionLength(this.getCableConnectionType())) > 8.0) continue;
                switch (dir) {
                    case DOWN: {
                        bch.addBox(6.0, dist, 6.0, 10.0, 6.0, 10.0);
                        continue block16;
                    }
                    case EAST: {
                        bch.addBox(10.0, 6.0, 6.0, 16.0 - dist, 10.0, 10.0);
                        continue block16;
                    }
                    case NORTH: {
                        bch.addBox(6.0, 6.0, dist, 10.0, 10.0, 6.0);
                        continue block16;
                    }
                    case SOUTH: {
                        bch.addBox(6.0, 6.0, 10.0, 10.0, 10.0, 16.0 - dist);
                        continue block16;
                    }
                    case UP: {
                        bch.addBox(6.0, 10.0, 6.0, 10.0, 16.0 - dist, 10.0);
                        continue block16;
                    }
                    case WEST: {
                        bch.addBox(dist, 6.0, 6.0, 6.0, 10.0, 10.0);
                        continue block16;
                    }
                }
            }
        }
        for (AEPartLocation of : this.getConnections()) {
            switch (of) {
                case DOWN: {
                    bch.addBox(6.0, 0.0, 6.0, 10.0, 6.0, 10.0);
                    break;
                }
                case EAST: {
                    bch.addBox(10.0, 6.0, 6.0, 16.0, 10.0, 10.0);
                    break;
                }
                case NORTH: {
                    bch.addBox(6.0, 6.0, 0.0, 10.0, 10.0, 6.0);
                    break;
                }
                case SOUTH: {
                    bch.addBox(6.0, 6.0, 10.0, 10.0, 10.0, 16.0);
                    break;
                }
                case UP: {
                    bch.addBox(6.0, 10.0, 6.0, 10.0, 16.0, 10.0);
                    break;
                }
                case WEST: {
                    bch.addBox(0.0, 6.0, 6.0, 6.0, 10.0, 10.0);
                    break;
                }
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        IGridNode node;
        super.writeToNBT(data);
        if (Platform.isServer() && (node = this.getGridNode()) != null) {
            int howMany = 0;
            for (IGridConnection gc : node.getConnections()) {
                howMany = Math.max(gc.getUsedChannels(), howMany);
            }
            data.func_74774_a("usedChannels", (byte)howMany);
        }
    }

    @Override
    public void writeToStream(ByteBuf data) throws IOException {
        int flags = 0;
        boolean[] writeSide = new boolean[EnumFacing.values().length];
        int[] channelsPerSide = new int[EnumFacing.values().length];
        for (EnumFacing thisSide : EnumFacing.values()) {
            IPart part = this.getHost().getPart(thisSide);
            if (part == null) continue;
            writeSide[thisSide.ordinal()] = true;
            int channels = 0;
            if (part.getGridNode() != null) {
                IReadOnlyCollection<IGridConnection> set = part.getGridNode().getConnections();
                for (IGridConnection gc : set) {
                    channels = Math.max(channels, gc.getUsedChannels());
                }
            }
            channelsPerSide[thisSide.ordinal()] = channels;
        }
        IGridNode n = this.getGridNode();
        if (n != null) {
            for (IGridConnection gc : n.getConnections()) {
                AEPartLocation side = gc.getDirection(n);
                if (side == AEPartLocation.INTERNAL) continue;
                writeSide[side.ordinal()] = true;
                channelsPerSide[side.ordinal()] = gc.getUsedChannels();
                flags |= 1 << side.ordinal();
            }
        }
        try {
            if (this.getProxy().getEnergy().isNetworkPowered()) {
                flags |= 1 << AEPartLocation.INTERNAL.ordinal();
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        data.writeByte((int)((byte)flags));
        for (int i = 0; i < writeSide.length; ++i) {
            if (!writeSide[i]) continue;
            data.writeByte(channelsPerSide[i]);
        }
    }

    @Override
    public boolean readFromStream(ByteBuf data) throws IOException {
        byte cs = data.readByte();
        Object myC = this.getConnections().clone();
        boolean wasPowered = this.powered;
        this.powered = false;
        boolean channelsChanged = false;
        for (AEPartLocation d : AEPartLocation.values()) {
            boolean conOnSide;
            if (d == AEPartLocation.INTERNAL) {
                int id = 1 << d.ordinal();
                if (id != (cs & id)) continue;
                this.powered = true;
                continue;
            }
            boolean bl = conOnSide = (cs & 1 << d.ordinal()) != 0;
            if (conOnSide) {
                this.getConnections().add(d);
            } else {
                this.getConnections().remove((Object)d);
            }
            int ch = 0;
            if (conOnSide || this.getHost().getPart(d) != null) {
                ch = data.readByte() & 0xFF;
            }
            if (ch == this.getChannelsOnSide(d.ordinal())) continue;
            channelsChanged = true;
            this.setChannelsOnSide(d.ordinal(), ch);
        }
        return !((AbstractSet)myC).equals(this.getConnections()) || wasPowered != this.powered || channelsChanged;
    }

    int getChannelsOnSide(int i) {
        return this.channelsOnSide[i];
    }

    public int getChannelsOnSide(EnumFacing side) {
        if (!this.powered) {
            return 0;
        }
        return this.channelsOnSide[side.ordinal()];
    }

    void setChannelsOnSide(int i, int channels) {
        this.channelsOnSide[i] = channels;
    }

    EnumSet<AEPartLocation> getConnections() {
        return this.connections;
    }

    void setConnections(EnumSet<AEPartLocation> connections) {
        this.connections = connections;
    }
}

