/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.misc;

import appeng.api.AEApi;
import appeng.api.definitions.IMaterials;
import appeng.api.implementations.items.IGrowableCrystal;
import appeng.api.recipes.ResolverResult;
import appeng.core.AppEng;
import appeng.core.localization.ButtonToolTips;
import appeng.entity.EntityGrowingCrystal;
import appeng.entity.EntityIds;
import appeng.items.AEBaseItem;
import appeng.util.Platform;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class ItemCrystalSeed
extends AEBaseItem
implements IGrowableCrystal {
    static final int LEVEL_OFFSET = 200;
    static final int SINGLE_OFFSET = 600;
    public static final int CERTUS = 0;
    public static final int NETHER = 600;
    public static final int FLUIX = 1200;
    public static final int FINAL_STAGE = 1800;

    public ItemCrystalSeed() {
        this.func_77627_a(true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("appliedenergistics2", EntityGrowingCrystal.class.getName()), EntityGrowingCrystal.class, (String)("appliedenergistics2:" + EntityGrowingCrystal.class.getSimpleName()), (int)EntityIds.get(EntityGrowingCrystal.class), (Object)AppEng.instance(), (int)16, (int)4, (boolean)true);
    }

    @Nullable
    public static ResolverResult getResolver(int certus2) {
        return AEApi.instance().definitions().items().crystalSeed().maybeStack(1).map(crystalSeedStack -> {
            crystalSeedStack.func_77964_b(certus2);
            crystalSeedStack = ItemCrystalSeed.newStyle(crystalSeedStack);
            String itemName = crystalSeedStack.func_77973_b().getRegistryName().func_110623_a();
            return new ResolverResult(itemName, crystalSeedStack.func_77952_i(), crystalSeedStack.func_77978_p());
        }).orElse(null);
    }

    private static ItemStack newStyle(ItemStack itemStack) {
        ItemCrystalSeed.getProgress(itemStack);
        return itemStack;
    }

    static int getProgress(ItemStack is) {
        if (is.func_77942_o()) {
            return is.func_77978_p().func_74762_e("progress");
        }
        NBTTagCompound comp = Platform.openNbtData(is);
        int progress = is.func_77952_i();
        comp.func_74768_a("progress", progress);
        is.func_77964_b(is.func_77952_i() / 600 * 600);
        return progress;
    }

    @Override
    @Nullable
    public ItemStack triggerGrowth(ItemStack is) {
        Optional<ItemStack> quartzStack;
        int newDamage = ItemCrystalSeed.getProgress(is) + 1;
        IMaterials materials = AEApi.instance().definitions().materials();
        int size = is.func_190916_E();
        if (newDamage == 600 && (quartzStack = materials.purifiedCertusQuartzCrystal().maybeStack(size)).isPresent()) {
            return quartzStack.get();
        }
        if (newDamage == 1200 && (quartzStack = materials.purifiedNetherQuartzCrystal().maybeStack(size)).isPresent()) {
            return quartzStack.get();
        }
        if (newDamage == 1800 && (quartzStack = materials.purifiedFluixCrystal().maybeStack(size)).isPresent()) {
            return quartzStack.get();
        }
        if (newDamage > 1800) {
            return ItemStack.field_190927_a;
        }
        this.setProgress(is, newDamage);
        return is;
    }

    private void setProgress(ItemStack is, int newDamage) {
        NBTTagCompound comp = Platform.openNbtData(is);
        comp.func_74768_a("progress", newDamage);
        is.func_77964_b(is.func_77952_i() / 200 * 200);
    }

    @Override
    public float getMultiplier(Block blk, Material mat) {
        return 0.5f;
    }

    @Override
    public void addCheckedInformation(ItemStack stack, EntityPlayer player, List<String> lines, boolean displayMoreInfo) {
        lines.add(ButtonToolTips.DoesntDespawn.getLocal());
        int progress = ItemCrystalSeed.getProgress(stack) % 600;
        lines.add(Math.floor((float)progress / 6.0f) + "%");
        super.addCheckedInformation(stack, player, lines, displayMoreInfo);
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    public String func_77667_c(ItemStack is) {
        int damage = ItemCrystalSeed.getProgress(is);
        if (damage < 600) {
            return this.func_77658_a() + ".Certus";
        }
        if (damage < 1200) {
            return this.func_77658_a() + ".Nether";
        }
        if (damage < 1800) {
            return this.func_77658_a() + ".Fluix";
        }
        return this.func_77658_a();
    }

    public boolean func_77645_m() {
        return false;
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    public int getMaxDamage(ItemStack stack) {
        return 1800;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        EntityGrowingCrystal egc = new EntityGrowingCrystal(world, location.field_70165_t, location.field_70163_u, location.field_70161_v, itemstack);
        egc.field_70159_w = location.field_70159_w;
        egc.field_70181_x = location.field_70181_x;
        egc.field_70179_y = location.field_70179_y;
        egc.func_174867_a(40);
        return egc;
    }

    @Override
    protected void getCheckedSubItems(Item sameItem, CreativeTabs creativeTab, NonNullList<ItemStack> itemStacks) {
        itemStacks.add((Object)ItemCrystalSeed.newStyle(new ItemStack((Item)this, 1, 0)));
        itemStacks.add((Object)ItemCrystalSeed.newStyle(new ItemStack((Item)this, 1, 600)));
        itemStacks.add((Object)ItemCrystalSeed.newStyle(new ItemStack((Item)this, 1, 1200)));
        itemStacks.add((Object)ItemCrystalSeed.newStyle(new ItemStack((Item)this, 1, 200)));
        itemStacks.add((Object)ItemCrystalSeed.newStyle(new ItemStack((Item)this, 1, 800)));
        itemStacks.add((Object)ItemCrystalSeed.newStyle(new ItemStack((Item)this, 1, 1400)));
        itemStacks.add((Object)ItemCrystalSeed.newStyle(new ItemStack((Item)this, 1, 400)));
        itemStacks.add((Object)ItemCrystalSeed.newStyle(new ItemStack((Item)this, 1, 1000)));
        itemStacks.add((Object)ItemCrystalSeed.newStyle(new ItemStack((Item)this, 1, 1600)));
    }
}

