/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.opencomputers.environment;

import appeng.api.storage.data.IAEItemStack;
import appeng.core.AELog;
import appeng.integration.modules.opencomputers.SaveableGridProxy;
import java.util.Map;
import li.cil.oc.api.Network;
import li.cil.oc.api.driver.NamedBlock;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.prefab.AbstractManagedEnvironment;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class MENetworkEnvironmentBase
extends AbstractManagedEnvironment
implements NamedBlock {
    protected SaveableGridProxy gridProxy;
    public String ENVIRONMENT_NAME;
    protected World worldObj;
    private static final String GRIDPROXY_KEY = "gridproxy";
    private static final String WORLD_DIM_KEY = "dimension";

    public MENetworkEnvironmentBase(SaveableGridProxy tile, World world) {
        this(tile, "me_network", world);
    }

    public MENetworkEnvironmentBase(SaveableGridProxy tile, String name, World world) {
        this.gridProxy = tile;
        this.ENVIRONMENT_NAME = name;
        this.worldObj = world;
        this.setNode(Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(this.ENVIRONMENT_NAME).create());
    }

    public String preferredName() {
        return this.ENVIRONMENT_NAME;
    }

    public int priority() {
        return 5;
    }

    protected boolean filterMatches(IAEItemStack stack, Map filter) {
        return !(filter.get("damage") != null && !filter.get("damage").equals(stack.getItemDamage()) || filter.get("maxDamage") != null && !filter.get("maxDamage").equals(stack.getItemStack().func_77958_k()) || filter.get("size") != null && !filter.get("size").equals(stack.getStackSize()) && !filter.get("size").equals(0.0) || filter.get("maxSize") != null && !filter.get("maxSize").equals(stack.getItemStack().func_77976_d()) || filter.get("hasTag") != null && !filter.get("hasTag").equals(stack.hasTagCompound()) || filter.get("name") != null && !filter.get("name").equals(stack.getItem().getRegistryName().toString()) || filter.get("label") != null && !filter.get("label").equals(stack.getItemStack().func_82833_r()));
    }

    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        if (this.gridProxy == null) {
            AELog.info("load called, gridproxy is null!", new Object[0]);
            this.gridProxy.load(nbt.func_74775_l(GRIDPROXY_KEY));
        }
        if (this.worldObj == null) {
            AELog.info("load called, worldobj is null!", new Object[0]);
            this.worldObj = DimensionManager.getWorld((int)nbt.func_74762_e(WORLD_DIM_KEY));
        }
    }

    public void save(NBTTagCompound nbt) {
        super.save(nbt);
        nbt.func_74782_a(GRIDPROXY_KEY, (NBTBase)this.gridProxy.save());
        nbt.func_74768_a(WORLD_DIM_KEY, this.worldObj.field_73011_w.getDimension());
    }
}

