/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.opencomputers.environment;

import appeng.api.AEApi;
import appeng.api.implementations.tiles.IChestOrDrive;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.core.AELog;
import appeng.integration.modules.opencomputers.ConverterCellInventory;
import appeng.me.storage.DriveWatcher;
import appeng.tile.AEBaseInvTile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import li.cil.oc.api.Network;
import li.cil.oc.api.driver.NamedBlock;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.prefab.AbstractManagedEnvironment;
import li.cil.oc.api.prefab.AbstractValue;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;

public class MEChestOrDriveEnvironment
extends AbstractManagedEnvironment
implements NamedBlock {
    public static final String ENVIRONMENT_NAME_DRIVE = "me_drive";
    public static final String ENVIRONMENT_NAME_CHEST = "me_chest";
    protected World worldObj;
    protected IChestOrDrive drive;
    protected BlockPos drivePos;
    protected int driveDimension;
    protected Type myType;
    private ArrayList<CellInfo> loadNeeded = new ArrayList();
    private static final Object[] notPowered = new Object[]{null, "not powered"};

    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        if (this.worldObj == null) {
            AELog.error("World obj is null in ENvironment load!!", new Object[0]);
        }
    }

    public MEChestOrDriveEnvironment(World world, BlockPos pos, IChestOrDrive tile, Type type) {
        this.worldObj = world;
        this.drivePos = pos;
        this.drive = tile;
        this.driveDimension = this.worldObj.field_73011_w.getDimension();
        this.myType = type;
        this.setNode(Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(this.myType == Type.DRIVE ? ENVIRONMENT_NAME_DRIVE : ENVIRONMENT_NAME_CHEST).create());
    }

    protected boolean isPowered() {
        return this.drive.isPowered();
    }

    @Callback(doc="function():boolean -- Tests if the chest or drive is powered and usable")
    public Object[] isPowered(Context context, Arguments args) {
        return new Object[]{this.isPowered()};
    }

    @Callback(doc="function():Integer -- Get the number of cells inserted")
    public Object[] getCellCount(Context context, Arguments args) {
        if (!this.isPowered()) {
            return notPowered;
        }
        int foundCells = 0;
        for (int i = 0; i < this.drive.getCellCount(); ++i) {
            if (this.drive.getCellStatus(i) <= 0) continue;
            ++foundCells;
        }
        return new Object[]{foundCells};
    }

    private List<IMEInventoryHandler> getCells() {
        List<IMEInventoryHandler> cellArray = this.drive.getCellArray(StorageChannel.ITEMS);
        cellArray.addAll(this.drive.getCellArray(StorageChannel.FLUIDS));
        return cellArray;
    }

    protected static int getHandlerSlot(IMEInventoryHandler handler, IChestOrDrive drive, Type tileType) {
        IMEInventory internalHandler;
        ICellInventory cellInv = null;
        if (handler instanceof ICellInventoryHandler) {
            cellInv = ((ICellInventoryHandler)handler).getCellInv();
        } else if (handler instanceof DriveWatcher && (internalHandler = ((DriveWatcher)handler).getInternal()) instanceof ICellInventoryHandler) {
            cellInv = ((ICellInventoryHandler)internalHandler).getCellInv();
        }
        int cellSlot = -1;
        if (cellInv != null && drive instanceof AEBaseInvTile) {
            int startSlot;
            ItemStack is = cellInv.getItemStack();
            AEBaseInvTile driveInv = (AEBaseInvTile)((Object)drive);
            for (int slot = startSlot = tileType == Type.DRIVE ? 0 : 1; slot < driveInv.func_70302_i_(); ++slot) {
                if (!is.equals(driveInv.func_70301_a(slot))) continue;
                cellSlot = slot;
                break;
            }
        }
        return cellSlot;
    }

    @Callback(doc="function():table -- Get the cells in the drive or chest")
    public Object[] getCells(Context context, Arguments args) {
        if (!this.isPowered()) {
            return notPowered;
        }
        try {
            ArrayList<CellInfo> cells = new ArrayList<CellInfo>();
            List<IMEInventoryHandler> cellList = this.getCells();
            for (IMEInventoryHandler handler : cellList) {
                cells.add(new CellInfo(handler, this.driveDimension, this.drivePos, this.drive, MEChestOrDriveEnvironment.getHandlerSlot(handler, this.drive, this.myType)));
            }
            return new Object[]{cells};
        }
        catch (Throwable t) {
            AELog.error("Error caught while enumerating cells", t);
            return new Object[]{null, "unknown error"};
        }
    }

    public String preferredName() {
        return this.myType == Type.DRIVE ? ENVIRONMENT_NAME_DRIVE : ENVIRONMENT_NAME_CHEST;
    }

    public int priority() {
        return 5;
    }

    public static class CellInfo
    extends AbstractValue {
        private int containerSlot;
        private IMEInventoryHandler handler = null;
        private int containerDim;
        private BlockPos containerPos = null;
        private IChestOrDrive container = null;

        public CellInfo() {
        }

        public CellInfo(IMEInventoryHandler cell, int dim, BlockPos pos, IChestOrDrive container, int slot) {
            this.containerSlot = slot;
            this.handler = cell;
            this.containerDim = dim;
            this.containerPos = pos;
            this.container = container;
        }

        @Callback(doc="function():Integer -- Get the slot in which this cell exist in its drive/chest")
        public Object[] getSlot(Context context, Arguments args) {
            return new Object[]{this.containerSlot};
        }

        @Callback(doc="function():table -- Get the cell stats")
        public Object[] getInfo(Context context, Arguments args) {
            if (this.handler == null || this.container == null) {
                this.load();
            }
            if (this.handler == null || this.container == null) {
                return new Object[]{null, "CellInfo not loaded correctly"};
            }
            try {
                IMEInventory internalHandler;
                HashMap<Object, Object> output = new HashMap<Object, Object>();
                ICellInventory cellInv = null;
                if (this.handler instanceof ICellInventoryHandler) {
                    cellInv = ((ICellInventoryHandler)this.handler).getCellInv();
                } else if (this.handler instanceof DriveWatcher && (internalHandler = ((DriveWatcher)this.handler).getInternal()) instanceof ICellInventoryHandler) {
                    cellInv = ((ICellInventoryHandler)internalHandler).getCellInv();
                }
                if (cellInv != null) {
                    ConverterCellInventory.convertCellInv(cellInv, output);
                    IInventory formatInv = cellInv.getConfigInventory();
                    ArrayList<ItemStack> formatted = new ArrayList<ItemStack>();
                    for (int slot = 0; slot < formatInv.func_70302_i_(); ++slot) {
                        ItemStack is = formatInv.func_70301_a(slot);
                        if (is == null) continue;
                        formatted.add(is);
                    }
                    output.put("preformattedItems", formatted);
                    return new Object[]{output};
                }
            }
            catch (Throwable t) {
                AELog.error("Error caught while getting cell info", t);
            }
            return new Object[0];
        }

        @Callback(doc="function():table -- Get the list of items/fluids stored in this cell")
        public Object[] getItemsStored(Context context, Arguments args) {
            if (this.handler == null || this.container == null) {
                this.load();
            }
            if (this.handler == null) {
                return new Object[]{null, "CellInfo not loaded correctly"};
            }
            try {
                IItemList<IAEStack<IAEItemStack>> storedList = null;
                if (this.handler.getChannel() == StorageChannel.ITEMS) {
                    storedList = AEApi.instance().storage().createItemList();
                } else if (this.handler.getChannel() == StorageChannel.FLUIDS) {
                    storedList = AEApi.instance().storage().createFluidList();
                } else {
                    return new Object[]{null, "Unknown storage channel"};
                }
                this.handler.getAvailableItems(storedList);
                return new Object[]{storedList};
            }
            catch (Throwable t) {
                AELog.error("Error caught while getting cell contents", t);
                return new Object[0];
            }
        }

        private void load() {
            try {
                WorldServer myWorld = DimensionManager.getWorld((int)this.containerDim);
                TileEntity tile = myWorld.func_175726_f(this.containerPos).func_177424_a(this.containerPos, Chunk.EnumCreateEntityType.CHECK);
                if (tile != null && tile instanceof IChestOrDrive && tile instanceof AEBaseInvTile) {
                    this.container = (IChestOrDrive)tile;
                    ItemStack is = ((AEBaseInvTile)tile).func_70301_a(this.containerSlot);
                    if (is != null) {
                        IMEInventoryHandler handler = AEApi.instance().registries().cell().getCellInventory(is, this.container, StorageChannel.ITEMS);
                        if (handler == null) {
                            handler = AEApi.instance().registries().cell().getCellInventory(is, this.container, StorageChannel.FLUIDS);
                        }
                        if (handler != null && handler instanceof ICellInventoryHandler) {
                            this.handler = handler;
                        }
                    }
                }
            }
            catch (Throwable t) {
                AELog.error("Could not reload CellInfo properly", t);
            }
        }

        public void load(NBTTagCompound nbt) {
            super.load(nbt);
            this.containerSlot = nbt.func_74762_e("slot");
            this.containerDim = nbt.func_74762_e("dimension");
            this.containerPos = NBTUtil.func_186861_c((NBTTagCompound)nbt.func_74775_l("pos"));
        }

        public void save(NBTTagCompound nbt) {
            super.save(nbt);
            nbt.func_74768_a("slot", this.containerSlot);
            nbt.func_74768_a("dimension", this.containerDim);
            nbt.func_74782_a("pos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.containerPos));
        }
    }

    public static enum Type {
        DRIVE,
        CHEST;

    }
}

