/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.opencomputers.environment;

import appeng.helpers.IInterfaceHost;
import appeng.integration.modules.opencomputers.driver.InterfaceDriver;
import appeng.integration.modules.opencomputers.environment.ConfigurableEnvironmentBase;
import appeng.tile.misc.TileInterface;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class InterfaceEnvironment
extends ConfigurableEnvironmentBase {
    private InterfaceType myType;

    public InterfaceEnvironment(TileEntity tileParent) {
        super("interface", tileParent);
        assert (InterfaceDriver.hasInterface(tileParent));
        this.myType = tileParent instanceof TileInterface ? InterfaceType.BLOCK : InterfaceType.PART;
    }

    @Callback(doc="function(side:number[, slot:number]):table -- Get the configuration of the interface pointing in the specified direction.")
    public Object[] getInterfaceConfiguration(Context context, Arguments args) {
        int side = args.optInteger(0, -1);
        if (this.myType == InterfaceType.PART && (side < 0 || side > 5)) {
            throw new IllegalArgumentException("invalid side");
        }
        IInventory configInv = this.getConfigInventory(EnumFacing.values()[side], this.myType == InterfaceType.BLOCK, IInterfaceHost.class);
        int slot = args.optInteger(1, 1) - 1;
        if (slot <= -1 || slot >= configInv.func_70302_i_()) {
            throw new IllegalArgumentException("invalid slot");
        }
        return new Object[]{configInv.func_70301_a(slot)};
    }

    @Callback(doc="function(side:number[, slot:number][, database:address, entry:number[, size:number]]):boolean -- Configure the interface pointing in the specified direction.")
    public Object[] setInterfaceConfiguration(Context context, Arguments args) {
        int side = args.optInteger(0, -1);
        if (this.myType == InterfaceType.PART && (side < 0 || side > 5)) {
            throw new IllegalArgumentException("invalid side");
        }
        IInventory configInv = this.getConfigInventory(EnumFacing.values()[side], this.myType == InterfaceType.BLOCK, IInterfaceHost.class);
        return this.setConfiguration(context, args, configInv);
    }

    @Callback(doc="function():table -- Get a list of all sides with an interface part. Returns -1 if an interface block")
    public Object[] getInterfaces(Context context, Arguments args) {
        return this.getValidSides(IInterfaceHost.class);
    }

    private static enum InterfaceType {
        BLOCK,
        PART;

    }
}

