/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.opencomputers.environment;

import appeng.integration.modules.opencomputers.driver.ImportBusDriver;
import appeng.integration.modules.opencomputers.environment.ConfigurableEnvironmentBase;
import appeng.parts.automation.PartImportBus;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class ImportBusEnvironment
extends ConfigurableEnvironmentBase {
    public ImportBusEnvironment(TileEntity tileParent) {
        super("import bus", tileParent);
        assert (ImportBusDriver.hasImportBus(tileParent));
    }

    @Callback(doc="function(side:number[, slot:number]):table -- Get the configuration of the import bus pointing in the specified direction.")
    public Object[] getImportConfiguration(Context context, Arguments args) {
        int side = args.optInteger(0, -1);
        if (side < 0 || side > 5) {
            throw new IllegalArgumentException("invalid side");
        }
        IInventory configInv = this.getConfigInventory(EnumFacing.values()[side], false, PartImportBus.class);
        int slot = args.optInteger(1, 1) - 1;
        if (slot <= -1 || slot >= configInv.func_70302_i_()) {
            throw new IllegalArgumentException("invalid slot");
        }
        return new Object[]{configInv.func_70301_a(slot)};
    }

    @Callback(doc="function(side:number[, slot:number][, database:address, entry:number[, size:number]]):boolean -- Configure the import bus pointing in the specified direction.")
    public Object[] setImportConfiguration(Context context, Arguments args) {
        int side = args.optInteger(0, -1);
        if (side < 0 || side > 5) {
            throw new IllegalArgumentException("invalid side");
        }
        IInventory configInv = this.getConfigInventory(EnumFacing.values()[side], false, PartImportBus.class);
        return this.setConfiguration(context, args, configInv);
    }

    @Callback(doc="function():table -- Get a list of all sides with an import bus")
    public Object[] getImportBusses(Context context, Arguments args) {
        return this.getValidSides(PartImportBus.class);
    }
}

