/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.opencomputers.environment;

import appeng.api.implementations.tiles.ISegmentedInventory;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.helpers.IInterfaceHost;
import java.util.ArrayList;
import li.cil.oc.api.Network;
import li.cil.oc.api.driver.NamedBlock;
import li.cil.oc.api.internal.Database;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Component;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.prefab.AbstractManagedEnvironment;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class ConfigurableEnvironmentBase
extends AbstractManagedEnvironment
implements NamedBlock {
    public static String ENVIRONMENT_NAME = "me_network";
    protected TileEntity tileParent;
    protected String meName;

    public ConfigurableEnvironmentBase(String name, TileEntity tileParent) {
        this.meName = name;
        this.tileParent = tileParent;
        this.setNode(Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(ENVIRONMENT_NAME).create());
    }

    protected IInventory getConfigInventory(EnumFacing side, boolean isBlock, Class<? extends ISegmentedInventory> expectedClass) {
        if (isBlock) {
            return ((IInterfaceHost)this.tileParent).getInventoryByName("config");
        }
        IPart part = ((IPartHost)this.tileParent).getPart(side);
        if (!expectedClass.isInstance(part)) {
            throw new IllegalArgumentException("no " + this.meName);
        }
        return ((ISegmentedInventory)((Object)part)).getInventoryByName("config");
    }

    protected Object[] setConfiguration(Context context, Arguments args, IInventory configInv) {
        int slot = 0;
        if (args.isInteger(1) && ((slot = args.checkInteger(1) - 1) <= -1 || slot >= configInv.func_70302_i_())) {
            throw new IllegalArgumentException("invalid slot");
        }
        ItemStack stackToSet = ItemStack.field_190927_a;
        if (args.count() > 2) {
            int size;
            int entry;
            String dbAddress;
            if (args.isString(1)) {
                dbAddress = args.checkString(1);
                entry = args.checkInteger(2) - 1;
                size = args.optInteger(3, 1);
            } else {
                dbAddress = args.checkString(2);
                entry = args.checkInteger(3) - 1;
                size = args.optInteger(4, 1);
            }
            Node addressed = this.node().network().node(dbAddress);
            if (addressed == null || !(addressed instanceof Component) || !(addressed.host() instanceof Database)) {
                throw new IllegalArgumentException(addressed == null ? "no such component" : "not a database");
            }
            Database database = (Database)addressed.host();
            int databaseSlots = database.size();
            if (entry < 0 || entry > databaseSlots - 1) {
                throw new IllegalArgumentException("invalid entry number");
            }
            stackToSet = database.getStackInSlot(entry);
            if (!stackToSet.func_190926_b()) {
                stackToSet = stackToSet.func_77946_l();
                stackToSet.func_190920_e(Math.min(size, stackToSet.func_77976_d()));
            }
        }
        configInv.func_70299_a(slot, stackToSet);
        context.pause(0.5);
        return new Object[]{true};
    }

    protected Object[] getValidSides(Class<? extends ISegmentedInventory> expectedClass) {
        ArrayList<Integer> sides = new ArrayList<Integer>();
        if (this.tileParent instanceof IPartHost) {
            IPartHost host = (IPartHost)this.tileParent;
            for (EnumFacing side : EnumFacing.values()) {
                IPart part = host.getPart(side);
                if (part == null || !expectedClass.isInstance(part)) continue;
                sides.add(side.func_176745_a());
            }
        } else {
            sides.add(-1);
        }
        return new Object[]{sides};
    }

    public String preferredName() {
        return ENVIRONMENT_NAME;
    }

    public int priority() {
        return 5;
    }
}

