/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.opencomputers.driver;

import appeng.api.AEApi;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.core.AELog;
import appeng.integration.modules.opencomputers.environment.InterfaceEnvironment;
import appeng.me.helpers.IGridProxyable;
import appeng.parts.misc.PartInterface;
import appeng.tile.misc.TileInterface;
import li.cil.oc.api.driver.DriverBlock;
import li.cil.oc.api.network.ManagedEnvironment;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class InterfaceDriver
implements DriverBlock {
    public static boolean isInterface(World world, BlockPos pos, EnumFacing side) {
        try {
            TileEntity te;
            if (AEApi.instance().definitions().blocks().multiPart().isSameAs((IBlockAccess)world, pos) && (te = world.func_175625_s(pos)) != null && te instanceof IPartHost) {
                IPart part = ((IPartHost)te).getPart(side.func_176734_d());
                return part != null && part instanceof PartInterface;
            }
            return AEApi.instance().definitions().blocks().iface().isSameAs((IBlockAccess)world, pos);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean hasInterface(TileEntity tile) {
        if (tile == null) {
            return false;
        }
        if (tile instanceof TileInterface) {
            return true;
        }
        if (tile instanceof IPartHost) {
            IPartHost host = (IPartHost)tile;
            for (EnumFacing side : EnumFacing.values()) {
                IPart part = host.getPart(side);
                if (part == null || !(part instanceof PartInterface)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasInterface(World world, BlockPos pos) {
        try {
            TileEntity te;
            if (AEApi.instance().definitions().blocks().multiPart().isSameAs((IBlockAccess)world, pos) && (te = world.func_175625_s(pos)) != null && te instanceof IPartHost) {
                IPartHost host = (IPartHost)te;
                for (EnumFacing side : EnumFacing.values()) {
                    IPart part = host.getPart(side);
                    if (part == null || !(part instanceof PartInterface)) continue;
                    return true;
                }
            }
            return AEApi.instance().definitions().blocks().iface().isSameAs((IBlockAccess)world, pos);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean worksWith(World world, BlockPos pos, EnumFacing side) {
        return InterfaceDriver.hasInterface(world, pos);
    }

    public ManagedEnvironment createEnvironment(World world, BlockPos pos, EnumFacing side) {
        if (this.worksWith(world, pos, side)) {
            try {
                TileEntity tile = world.func_175625_s(pos);
                if (tile != null) {
                    return new InterfaceEnvironment(tile);
                }
            }
            catch (Exception e) {
                AELog.error("Error occurred during InterfaceEnvironment creation.", e);
            }
        }
        return null;
    }

    public static IGridProxyable getIfaceGrid(TileEntity tile, EnumFacing side) {
        try {
            if (tile != null && tile instanceof IGridProxyable) {
                return (IGridProxyable)tile;
            }
            if (tile != null && tile instanceof IPartHost) {
                IPart part = ((IPartHost)tile).getPart(side.func_176734_d());
                if (part != null && part instanceof PartInterface) {
                    return (IGridProxyable)((Object)part);
                }
            } else if (tile != null) {
                AELog.error(tile.getClass().toString() + " does not implement IGridProxyable!", new Object[0]);
            }
        }
        catch (Exception e) {
            AELog.error("Error occurred getting IGridProxyable creation.", e);
        }
        return null;
    }
}

