/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.opencomputers.driver;

import appeng.api.AEApi;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.core.AELog;
import appeng.integration.modules.opencomputers.environment.ImportBusEnvironment;
import appeng.parts.automation.PartImportBus;
import li.cil.oc.api.driver.DriverBlock;
import li.cil.oc.api.network.ManagedEnvironment;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ImportBusDriver
implements DriverBlock {
    public static boolean hasImportBus(TileEntity tile) {
        if (tile == null) {
            return false;
        }
        if (tile instanceof IPartHost) {
            IPartHost host = (IPartHost)tile;
            for (EnumFacing side : EnumFacing.values()) {
                IPart part = host.getPart(side);
                if (part == null || !(part instanceof PartImportBus)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasImportBus(World world, BlockPos pos) {
        try {
            TileEntity te;
            if (AEApi.instance().definitions().blocks().multiPart().isSameAs((IBlockAccess)world, pos) && (te = world.func_175625_s(pos)) != null && te instanceof IPartHost) {
                IPartHost host = (IPartHost)te;
                for (EnumFacing side : EnumFacing.values()) {
                    IPart part = host.getPart(side);
                    if (part == null || !(part instanceof PartImportBus)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean worksWith(World world, BlockPos pos, EnumFacing side) {
        return ImportBusDriver.hasImportBus(world, pos);
    }

    public ManagedEnvironment createEnvironment(World world, BlockPos pos, EnumFacing side) {
        if (this.worksWith(world, pos, side)) {
            try {
                TileEntity tile = world.func_175625_s(pos);
                if (tile != null) {
                    return new ImportBusEnvironment(tile);
                }
            }
            catch (Exception e) {
                AELog.error("Error occurred during ImportBusEnvironment creation.", e);
            }
        }
        return null;
    }
}

