/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.opencomputers;

import appeng.api.util.DimensionalCoord;
import appeng.core.AELog;
import appeng.integration.modules.opencomputers.driver.NetworkDriver;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.IGridProxyable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class SaveableGridProxy {
    private IGridProxyable gridProxy;
    private EnumFacing side;
    private BlockPos cachedBlockPos;
    private int cachedDimension;
    private boolean loaded;

    public SaveableGridProxy() {
        this.loaded = false;
    }

    public SaveableGridProxy(IGridProxyable iGridProxyable, EnumFacing side) {
        this.gridProxy = iGridProxyable;
        this.side = side;
        this.loaded = true;
    }

    public NBTTagCompound save() {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.loaded) {
            DimensionalCoord location = this.gridProxy.getLocation();
            nbt.func_74768_a("x", location.x);
            nbt.func_74768_a("y", location.y);
            nbt.func_74768_a("z", location.z);
            nbt.func_74768_a("dimension", location.getWorld().field_73011_w.getDimension());
            nbt.func_74768_a("side", this.side.func_176745_a());
        } else {
            nbt.func_74768_a("x", this.cachedBlockPos.func_177958_n());
            nbt.func_74768_a("y", this.cachedBlockPos.func_177956_o());
            nbt.func_74768_a("z", this.cachedBlockPos.func_177956_o());
            nbt.func_74768_a("dimension", this.cachedDimension);
            nbt.func_74768_a("side", this.side.func_176745_a());
        }
        return nbt;
    }

    public void tryLoadGridProxy() {
        WorldServer world = DimensionManager.getWorld((int)this.cachedDimension);
        this.gridProxy = NetworkDriver.getGridProxyable((World)world, this.cachedBlockPos, this.side);
        if (this.gridProxy != null) {
            this.loaded = true;
        }
    }

    public IGridProxyable getGridProxyable() {
        if (!this.loaded | this.gridProxy == null) {
            this.tryLoadGridProxy();
        }
        return this.gridProxy;
    }

    public AENetworkProxy getProxy() {
        if (this.getGridProxyable() != null) {
            return this.getGridProxyable().getProxy();
        }
        AELog.error("Gridproxy not loaded, and network driver couldnt find it!", new Object[0]);
        return null;
    }

    public void load(NBTTagCompound saved) {
        try {
            this.cachedDimension = saved.func_74762_e("dimension");
            this.cachedBlockPos = new BlockPos(saved.func_74762_e("x"), saved.func_74762_e("y"), saved.func_74762_e("z"));
            this.side = EnumFacing.func_82600_a((int)saved.func_74762_e("side"));
        }
        catch (Exception e) {
            AELog.error("Couldn't load SaveableGridProxy", e);
            AELog.info(saved.toString(), new Object[0]);
        }
    }
}

