/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.opencomputers;

import appeng.api.AEApi;
import appeng.api.IAppEngApi;
import appeng.api.config.TunnelType;
import appeng.api.features.IP2PTunnelRegistry;
import appeng.api.implementations.items.IAEWrench;
import appeng.api.parts.IPartHelper;
import appeng.core.AELog;
import appeng.integration.IIntegrationModule;
import appeng.integration.IntegrationHelper;
import appeng.integration.IntegrationRegistry;
import appeng.integration.IntegrationType;
import appeng.integration.modules.opencomputers.ConverterAEStack;
import appeng.integration.modules.opencomputers.ConverterCellInventory;
import appeng.integration.modules.opencomputers.driver.ExportBusDriver;
import appeng.integration.modules.opencomputers.driver.ImportBusDriver;
import appeng.integration.modules.opencomputers.driver.InterfaceDriver;
import appeng.integration.modules.opencomputers.driver.NetworkDriver;
import li.cil.oc.api.Driver;
import li.cil.oc.api.IMC;
import li.cil.oc.api.Items;
import li.cil.oc.api.Network;
import li.cil.oc.api.detail.ItemInfo;
import li.cil.oc.api.driver.Converter;
import li.cil.oc.api.driver.DriverBlock;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.SidedEnvironment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;

public class OpenComputers
implements IIntegrationModule {
    public static OpenComputers instance;

    public OpenComputers() {
        IntegrationHelper.testClassExistence(this, Items.class);
        IntegrationHelper.testClassExistence(this, Network.class);
        IntegrationHelper.testClassExistence(this, Environment.class);
        IntegrationHelper.testClassExistence(this, SidedEnvironment.class);
        IntegrationHelper.testClassExistence(this, Node.class);
        IntegrationHelper.testClassExistence(this, Message.class);
        IntegrationHelper.testClassExistence(this, IMC.class);
        IntegrationHelper.testClassExistence(this, Driver.class);
    }

    @Override
    public void init() {
        IAppEngApi api = AEApi.instance();
        IPartHelper partHelper = api.partHelper();
        if (IntegrationRegistry.INSTANCE.isEnabled(IntegrationType.OpenComputers)) {
            partHelper.registerNewLayer("appeng.parts.layers.LayerSidedEnvironment", "li.cil.oc.api.network.SidedEnvironment");
        }
        AELog.info("Adding AE2 OC Drivers", new Object[0]);
        Driver.add((DriverBlock)new NetworkDriver());
        Driver.add((DriverBlock)new InterfaceDriver());
        Driver.add((DriverBlock)new ExportBusDriver());
        Driver.add((DriverBlock)new ImportBusDriver());
        Driver.add((Converter)new ConverterCellInventory());
        Driver.add((Converter)new ConverterAEStack());
        IMC.registerWrenchTool((String)(this.getClass().getName() + ".useWrench"));
        IMC.registerWrenchToolCheck((String)(this.getClass().getName() + ".isWrench"));
    }

    @Override
    public void postInit() {
        IP2PTunnelRegistry registry = AEApi.instance().registries().p2pTunnel();
        this.addAttunement(registry, "cable");
        this.addAttunement(registry, "adapter");
        this.addAttunement(registry, "switch");
        this.addAttunement(registry, "access_point");
        this.addAttunement(registry, "lan_card");
        this.addAttunement(registry, "linked_card");
        this.addAttunement(registry, "wlan_card");
        this.addAttunement(registry, "analyzer");
    }

    private void addAttunement(IP2PTunnelRegistry registry, String name) {
        ItemInfo info = Items.get((String)name);
        if (info != null) {
            registry.addNewAttunement(info.createItemStack(1), TunnelType.COMPUTER_MESSAGE);
        }
    }

    public static boolean useWrench(EntityPlayer player, BlockPos pos, boolean changeDurability) {
        ItemStack mainhand = player.func_184586_b(EnumHand.MAIN_HAND);
        ItemStack offhand = player.func_184586_b(EnumHand.OFF_HAND);
        if (mainhand != null && mainhand.func_77973_b() instanceof IAEWrench) {
            return ((IAEWrench)mainhand.func_77973_b()).canWrench(mainhand, player, pos);
        }
        if (offhand != null && offhand.func_77973_b() instanceof IAEWrench) {
            return ((IAEWrench)offhand.func_77973_b()).canWrench(offhand, player, pos);
        }
        return false;
    }

    public static boolean isWrench(ItemStack stack) {
        return stack != null && !stack.func_190926_b() && stack.func_77973_b() instanceof IAEWrench;
    }
}

