/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.opencomputers;

import appeng.api.AEApi;
import appeng.api.networking.crafting.ICraftingLink;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.prefab.AbstractValue;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class CraftingStatus
extends AbstractValue {
    private boolean isComputing = true;
    private ICraftingLink link;
    private boolean failed = false;
    private String reason = "no link";

    public void setLink(ICraftingLink value) {
        this.isComputing = false;
        this.link = value;
    }

    public void fail(String reason) {
        this.isComputing = false;
        this.failed = true;
        this.reason = "request failed: " + reason;
    }

    @Callback(doc="function():boolean -- Get whether the crafting request has been canceled.")
    public Object[] isCanceled(Context context, Arguments args) {
        if (this.isComputing) {
            return new Object[]{false, "computing"};
        }
        if (this.link != null) {
            return new Object[]{this.link.isCanceled()};
        }
        return new Object[]{this.failed, this.reason};
    }

    @Callback(doc="function():boolean -- Get whether the crafting request is done.")
    public Object[] isDone(Context context, Arguments args) {
        if (this.isComputing) {
            return new Object[]{false, "computing"};
        }
        if (this.link != null) {
            return new Object[]{this.link.isDone()};
        }
        return new Object[]{!this.failed, this.reason};
    }

    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        this.isComputing = nbt.func_74767_n("isComputing");
        this.failed = nbt.func_74767_n("failed");
        this.reason = nbt.func_74779_i("reason");
        if (nbt.func_74764_b("link")) {
            this.link = AEApi.instance().storage().loadCraftingLink(nbt.func_74775_l("link"), null);
        }
    }

    public void save(NBTTagCompound nbt) {
        super.save(nbt);
        nbt.func_74757_a("isComputing", this.isComputing);
        if (this.link != null) {
            NBTTagCompound linkNBT = new NBTTagCompound();
            this.link.writeToNBT(linkNBT);
            nbt.func_74782_a("link", (NBTBase)linkNBT);
        }
        nbt.func_74757_a("failed", this.failed);
        nbt.func_74778_a("reason", this.reason);
    }
}

