/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.api.config.CondenserOutput;
import appeng.integration.modules.jei.CondenserOutputWrapper;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

class CondenserOutputHandler
implements IRecipeHandler<CondenserOutput> {
    private final ItemStack matterBall;
    private final ItemStack singularity;
    private final IDrawable iconButtonMatterBall;
    private final IDrawable iconButtonSingularity;

    public CondenserOutputHandler(IGuiHelper guiHelper, ItemStack matterBall, ItemStack singularity) {
        this.matterBall = matterBall;
        this.singularity = singularity;
        ResourceLocation statesLocation = new ResourceLocation("appliedenergistics2", "textures/guis/states.png");
        this.iconButtonMatterBall = guiHelper.createDrawable(statesLocation, 16, 112, 14, 14, 28, 0, 78, 0);
        this.iconButtonSingularity = guiHelper.createDrawable(statesLocation, 32, 112, 14, 14, 28, 0, 78, 0);
    }

    public Class<CondenserOutput> getRecipeClass() {
        return CondenserOutput.class;
    }

    public String getRecipeCategoryUid(CondenserOutput recipe) {
        return "appliedenergistics2.condenser";
    }

    public IRecipeWrapper getRecipeWrapper(CondenserOutput recipe) {
        switch (recipe) {
            case MATTER_BALLS: {
                return new CondenserOutputWrapper(recipe, this.matterBall, this.iconButtonMatterBall);
            }
            case SINGULARITY: {
                return new CondenserOutputWrapper(recipe, this.singularity, this.iconButtonSingularity);
            }
        }
        return null;
    }

    public boolean isRecipeValid(CondenserOutput recipe) {
        switch (recipe) {
            case MATTER_BALLS: {
                return !this.matterBall.func_190926_b();
            }
            case SINGULARITY: {
                return !this.singularity.func_190926_b();
            }
        }
        return false;
    }
}

