/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.ic2;

import appeng.api.config.PowerUnits;
import appeng.integration.abstraction.IC2PowerSink;
import appeng.tile.powersink.IExternalPowerSink;
import ic2.api.energy.prefab.BasicSink;
import ic2.api.energy.tile.IEnergyEmitter;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class IC2PowerSinkAdapter
extends BasicSink
implements IC2PowerSink {
    private final IExternalPowerSink powerSink;
    private final Set<EnumFacing> validFaces = EnumSet.allOf(EnumFacing.class);

    public IC2PowerSinkAdapter(TileEntity tileEntity, IExternalPowerSink powerSink) {
        super(tileEntity, 0.0, Integer.MAX_VALUE);
        this.powerSink = powerSink;
    }

    @Override
    public void invalidate() {
        super.onChunkUnload();
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
    }

    @Override
    public void onLoad() {
    }

    public double getDemandedEnergy() {
        return this.powerSink.getExternalPowerDemand(PowerUnits.EU, Double.MAX_VALUE);
    }

    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        return PowerUnits.EU.convertTo(PowerUnits.AE, this.powerSink.injectExternalPower(PowerUnits.EU, amount));
    }

    public boolean acceptsEnergyFrom(IEnergyEmitter iEnergyEmitter, EnumFacing side) {
        return this.validFaces.contains(side);
    }

    @Override
    public void setValidFaces(Set<EnumFacing> faces) {
        this.validFaces.clear();
        this.validFaces.addAll(faces);
    }
}

