/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration;

import appeng.integration.IIntegrationModule;
import appeng.integration.IntegrationSide;
import appeng.integration.Integrations;
import appeng.integration.MissingIntegrationModuleException;
import appeng.integration.modules.ic2.IC2Module;
import appeng.integration.modules.jei.JEIModule;
import appeng.integration.modules.opencomputers.OpenComputers;
import appeng.integration.modules.rf.RFItemModule;
import appeng.integration.modules.rf.RFTileModule;
import appeng.integration.modules.theoneprobe.TheOneProbeModule;
import appeng.integration.modules.waila.WailaModule;

public enum IntegrationType {
    IC2(IntegrationSide.BOTH, "Industrial Craft 2", "ic2"){

        @Override
        public IIntegrationModule createInstance() {
            return Integrations.setIc2(new IC2Module());
        }
    }
    ,
    RF(IntegrationSide.BOTH, "RedstoneFlux Power - Tiles", "CoFHAPI"){

        @Override
        public IIntegrationModule createInstance() {
            return new RFTileModule();
        }
    }
    ,
    RFItem(IntegrationSide.BOTH, "RedstoneFlux Power - Items", "CoFHAPI"){

        @Override
        public IIntegrationModule createInstance() {
            return new RFItemModule();
        }
    }
    ,
    Waila(IntegrationSide.BOTH, "Waila", "waila"){

        @Override
        public IIntegrationModule createInstance() {
            return new WailaModule();
        }
    }
    ,
    JEI(IntegrationSide.CLIENT, "Just Enough Items", "jei"){

        @Override
        public IIntegrationModule createInstance() {
            return Integrations.setJei(new JEIModule());
        }
    }
    ,
    OpenComputers(IntegrationSide.BOTH, "OpenComputers", "opencomputers"){

        @Override
        public IIntegrationModule createInstance() {
            return new OpenComputers();
        }
    }
    ,
    THE_ONE_PROBE(IntegrationSide.BOTH, "TheOneProbe", "theoneprobe"){

        @Override
        public IIntegrationModule createInstance() {
            return new TheOneProbeModule();
        }
    };

    public final IntegrationSide side;
    public final String dspName;
    public final String modID;

    private IntegrationType(IntegrationSide side, String name, String modid) {
        this.side = side;
        this.dspName = name;
        this.modID = modid;
    }

    public IIntegrationModule createInstance() {
        throw new MissingIntegrationModuleException(this.name());
    }
}

