/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features.registries.inscriber;

import appeng.api.features.IInscriberRecipe;
import appeng.api.features.IInscriberRecipeBuilder;
import appeng.api.features.IInscriberRegistry;
import appeng.api.features.InscriberProcessType;
import appeng.core.features.registries.inscriber.InscriberRecipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public final class InscriberRegistry
implements IInscriberRegistry {
    private final Set<IInscriberRecipe> recipes;
    private final Set<ItemStack> optionals;
    private final Set<ItemStack> inputs = new HashSet<ItemStack>();

    public InscriberRegistry() {
        this.optionals = new HashSet<ItemStack>();
        this.recipes = new HashSet<IInscriberRecipe>();
    }

    @Override
    @Nonnull
    public Collection<IInscriberRecipe> getRecipes() {
        return Collections.unmodifiableCollection(this.recipes);
    }

    @Override
    @Nonnull
    public Set<ItemStack> getOptionals() {
        return this.optionals;
    }

    @Override
    @Nonnull
    public Set<ItemStack> getInputs() {
        return this.inputs;
    }

    @Override
    @Nonnull
    public IInscriberRecipeBuilder builder() {
        return new Builder();
    }

    @Override
    public void addRecipe(IInscriberRecipe recipe) {
        if (recipe == null) {
            throw new IllegalArgumentException("Tried to add an invalid (null) inscriber recipe to the registry.");
        }
        this.recipes.add(recipe);
        recipe.getTopOptional().ifPresent(this.optionals::add);
        recipe.getBottomOptional().ifPresent(this.optionals::add);
        this.inputs.addAll(recipe.getInputs());
    }

    @Override
    public void removeRecipe(IInscriberRecipe toBeRemovedRecipe) {
        Iterator<IInscriberRecipe> iterator = this.recipes.iterator();
        while (iterator.hasNext()) {
            IInscriberRecipe recipe = iterator.next();
            if (!recipe.equals(toBeRemovedRecipe)) continue;
            iterator.remove();
        }
    }

    private static final class Builder
    implements IInscriberRecipeBuilder {
        private List<ItemStack> inputs;
        private ItemStack output = ItemStack.field_190927_a;
        private ItemStack topOptional = ItemStack.field_190927_a;
        private ItemStack bottomOptional = ItemStack.field_190927_a;
        private InscriberProcessType type;

        private Builder() {
        }

        @Override
        @Nonnull
        public Builder withInputs(@Nonnull Collection<ItemStack> inputs) {
            this.inputs = new ArrayList<ItemStack>(inputs.size());
            this.inputs.addAll(inputs);
            return this;
        }

        @Override
        @Nonnull
        public Builder withOutput(@Nonnull ItemStack output) {
            this.output = output;
            return this;
        }

        @Override
        @Nonnull
        public Builder withTopOptional(@Nonnull ItemStack topOptional) {
            this.topOptional = topOptional;
            return this;
        }

        @Override
        @Nonnull
        public Builder withBottomOptional(@Nonnull ItemStack bottomOptional) {
            this.bottomOptional = bottomOptional;
            return this;
        }

        @Override
        @Nonnull
        public Builder withProcessType(@Nonnull InscriberProcessType type) {
            this.type = type;
            return this;
        }

        @Override
        @Nonnull
        public IInscriberRecipe build() {
            if (this.inputs == null) {
                throw new IllegalStateException("Input must be defined.");
            }
            if (this.inputs.isEmpty()) {
                throw new IllegalStateException("Input must have a size.");
            }
            if (this.output.func_190926_b()) {
                throw new IllegalStateException("Output must be defined.");
            }
            if (this.topOptional.func_190926_b() && this.bottomOptional.func_190926_b()) {
                throw new IllegalStateException("One optional must be defined.");
            }
            if (this.type == null) {
                throw new IllegalStateException("Process type must be defined.");
            }
            return new InscriberRecipe(this.inputs, this.output, this.topOptional, this.bottomOptional, this.type);
        }
    }
}

