/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features.registries.grinder;

import appeng.api.features.IGrinderRecipe;
import appeng.api.features.IGrinderRegistry;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.features.registries.grinder.AppEngGrinderRecipe;
import appeng.recipes.ores.IOreListener;
import appeng.recipes.ores.OreDictionaryHandler;
import appeng.util.Platform;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public final class GrinderRecipeManager
implements IGrinderRegistry,
IOreListener {
    private final Map<CacheKey, IGrinderRecipe> recipes = Maps.newHashMap();
    private final Map<ItemStack, String> ores = Maps.newHashMap();
    private final Map<ItemStack, String> ingots = Maps.newHashMap();
    private final Map<String, ItemStack> dusts = Maps.newHashMap();
    private final Map<String, Integer> dustToOreRatio = Maps.newHashMap();

    public GrinderRecipeManager() {
        this.addDustRatio("Obsidian", 1);
        this.addDustRatio("Charcoal", 1);
        this.addDustRatio("Coal", 1);
        this.addOre("Coal", new ItemStack(Items.field_151044_h));
        this.addOre("Charcoal", new ItemStack(Items.field_151044_h, 1, 1));
        this.addOre("NetherQuartz", new ItemStack(Blocks.field_150449_bY));
        this.addIngot("NetherQuartz", new ItemStack(Items.field_151128_bU));
        this.addOre("Gold", new ItemStack(Blocks.field_150352_o));
        this.addIngot("Gold", new ItemStack(Items.field_151043_k));
        this.addOre("Iron", new ItemStack(Blocks.field_150366_p));
        this.addIngot("Iron", new ItemStack(Items.field_151042_j));
        this.addOre("Obsidian", new ItemStack(Blocks.field_150343_Z));
        this.addIngot("Ender", new ItemStack(Items.field_151079_bi));
        this.addIngot("EnderPearl", new ItemStack(Items.field_151079_bi));
        this.addIngot("Wheat", new ItemStack(Items.field_151015_O));
        OreDictionaryHandler.INSTANCE.observe(this);
    }

    @Override
    public Collection<IGrinderRecipe> getRecipes() {
        return Collections.unmodifiableCollection(this.recipes.values());
    }

    @Override
    public void addRecipe(ItemStack in, ItemStack out, int cost) {
        Preconditions.checkNotNull((Object)in, (Object)"Null is not accepted as input itemstack.");
        Preconditions.checkNotNull((Object)out, (Object)"Null is not accepted as output itemstack.");
        Preconditions.checkArgument((cost > 0 ? 1 : 0) != 0, (Object)"Turns must be > 0");
        this.log("Allow Grinding of '%1$s' to '%2$s' for %3$d turn", Platform.getItemDisplayName(in), Platform.getItemDisplayName(out), cost);
        this.injectRecipe(new AppEngGrinderRecipe(this.copy(in), this.copy(out), cost));
    }

    @Override
    public void addRecipe(ItemStack in, ItemStack out, ItemStack optional, float chance, int cost) {
        Preconditions.checkNotNull((Object)in, (Object)"Null is not accepted as input itemstack.");
        Preconditions.checkNotNull((Object)out, (Object)"Null is not accepted as output itemstack.");
        Preconditions.checkNotNull((Object)optional, (Object)"Null is not accepted as optional itemstack.");
        Preconditions.checkArgument(((double)chance >= 0.0 && (double)chance <= 1.0 ? 1 : 0) != 0, (Object)"chance must be within 0.0 - 1.0.");
        Preconditions.checkArgument((cost > 0 ? 1 : 0) != 0, (Object)"Turns must be > 0");
        this.log("Allow Grinding of '%1$s' to '%2$s' with optional '%3$s' @ %4$.2f for %5$d", Platform.getItemDisplayName(in), Platform.getItemDisplayName(out), Platform.getItemDisplayName(optional), Float.valueOf(chance), cost);
        this.injectRecipe(new AppEngGrinderRecipe(this.copy(in), this.copy(out), this.copy(optional), chance, cost));
    }

    @Override
    public void addRecipe(ItemStack in, ItemStack out, ItemStack optional1, float chance1, ItemStack optional2, float chance2, int cost) {
        Preconditions.checkNotNull((Object)in, (Object)"Null is not accepted as input itemstack.");
        Preconditions.checkNotNull((Object)out, (Object)"Null is not accepted as output itemstack.");
        Preconditions.checkNotNull((Object)optional1, (Object)"Null is not accepted as optional itemstack.");
        Preconditions.checkArgument(((double)chance1 >= 0.0 && (double)chance1 <= 1.0 ? 1 : 0) != 0, (Object)"chance must be within 0.0 - 1.0.");
        Preconditions.checkNotNull((Object)optional2, (Object)"Null is not accepted as optional2 itemstack.");
        Preconditions.checkArgument(((double)chance2 >= 0.0 && (double)chance2 <= 1.0 ? 1 : 0) != 0, (Object)"chance2 must be within 0.0 - 1.0.");
        Preconditions.checkArgument((cost > 0 ? 1 : 0) != 0, (Object)"Turns must be > 0");
        this.log("Allow Grinding of '%1$s' to '%2$s' with optional '%3$s' @ %4$.2f and optional2 '%5$s' @ %6$.2f for %7$d", Platform.getItemDisplayName(in), Platform.getItemDisplayName(out), Platform.getItemDisplayName(optional1), Float.valueOf(chance1), Platform.getItemDisplayName(optional2), Float.valueOf(chance2), cost);
        this.injectRecipe(new AppEngGrinderRecipe(this.copy(in), this.copy(out), this.copy(optional1), this.copy(optional2), chance1, chance2, cost));
    }

    @Override
    public boolean removeRecipe(IGrinderRecipe recipe) {
        Preconditions.checkNotNull((Object)recipe, (Object)"Cannot remove null as recipe.");
        CacheKey key = new CacheKey(recipe.getInput());
        IGrinderRecipe removedRecipe = this.recipes.remove(key);
        this.log("Removed Grinding of '%1%s'", Platform.getItemDisplayName(recipe.getInput()));
        return removedRecipe != null;
    }

    @Override
    public IGrinderRecipe getRecipeForInput(ItemStack input) {
        this.log("Looking up recipe for '%1$s'", Platform.getItemDisplayName(input));
        if (input.func_190926_b()) {
            return null;
        }
        IGrinderRecipe recipe = this.recipes.get(new CacheKey(input));
        if (recipe == null) {
            return null;
        }
        this.log("Recipe for '%1$s' found '%2$s'", input.func_77977_a(), Platform.getItemDisplayName(recipe.getOutput()));
        return recipe;
    }

    @Override
    public void addDustRatio(String oredictName, int ratio) {
        Preconditions.checkNotNull((Object)oredictName);
        Preconditions.checkArgument((ratio > 0 ? 1 : 0) != 0);
        this.log("Added ratio for '%1$s' of %2$d", oredictName, ratio);
        this.dustToOreRatio.put(oredictName, ratio);
    }

    @Override
    public boolean removeDustRatio(String oredictName) {
        Preconditions.checkNotNull((Object)oredictName);
        this.log("Removed ratio for '%1$s'", oredictName);
        return this.dustToOreRatio.remove(oredictName) != null;
    }

    @Override
    public void oreRegistered(String name, ItemStack item) {
        if (!AEConfig.instance().getGrinderBlackList().contains(name) && (name.startsWith("ore") || name.startsWith("crystal") || name.startsWith("gem") || name.startsWith("ingot") || name.startsWith("dust"))) {
            for (String ore : AEConfig.instance().getGrinderOres()) {
                if (name.equals("ore" + ore)) {
                    this.addOre(ore, item);
                    continue;
                }
                if (name.equals("crystal" + ore) || name.equals("ingot" + ore) || name.equals("gem" + ore)) {
                    this.addIngot(ore, item);
                    continue;
                }
                if (!name.equals("dust" + ore)) continue;
                this.addDust(ore, item);
            }
        }
    }

    private void injectRecipe(AppEngGrinderRecipe appEngGrinderRecipe) {
        CacheKey cacheKey = new CacheKey(appEngGrinderRecipe.getInput());
        if (this.recipes.containsKey(cacheKey)) {
            this.log("Tried to add duplicate recipe for '%1$s'", Platform.getItemDisplayName(appEngGrinderRecipe.getInput()));
            return;
        }
        this.recipes.put(cacheKey, appEngGrinderRecipe);
    }

    private ItemStack copy(ItemStack is) {
        if (!is.func_190926_b()) {
            return is.func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    private int getDustToOreRatio(String name) {
        return this.dustToOreRatio.getOrDefault(name, 2);
    }

    private void addOre(String name, ItemStack item) {
        if (item.func_190926_b()) {
            return;
        }
        this.log("Adding Ore: '%1$s'", Platform.getItemDisplayName(item));
        this.ores.put(item, name);
        if (this.dusts.containsKey(name)) {
            ItemStack is = this.dusts.get(name).func_77946_l();
            int ratio = this.getDustToOreRatio(name);
            if (ratio > 1) {
                ItemStack extra = is.func_77946_l();
                extra.func_190920_e(ratio - 1);
                this.addRecipe(item, is, extra, (float)(AEConfig.instance().getOreDoublePercentage() / 100.0), 8);
            } else {
                this.addRecipe(item, is, 8);
            }
        }
    }

    private void addIngot(String name, ItemStack item) {
        if (item.func_190926_b()) {
            return;
        }
        this.log("Adding Ingot: '%1$s'", Platform.getItemDisplayName(item));
        this.ingots.put(item, name);
        if (this.dusts.containsKey(name)) {
            this.addRecipe(item, this.dusts.get(name), 4);
        }
    }

    private void addDust(String name, ItemStack item) {
        if (item.func_190926_b()) {
            return;
        }
        if (this.dusts.containsKey(name)) {
            this.log("Rejecting Dust: '%1$s'", Platform.getItemDisplayName(item));
            return;
        }
        this.log("Adding Dust: '%1$s'", Platform.getItemDisplayName(item));
        this.dusts.put(name, item);
        for (Map.Entry<ItemStack, String> d : this.ores.entrySet()) {
            if (!name.equals(d.getValue())) continue;
            ItemStack is = item.func_77946_l();
            is.func_190920_e(1);
            int ratio = this.getDustToOreRatio(name);
            if (ratio > 1) {
                ItemStack extra = is.func_77946_l();
                extra.func_190920_e(ratio - 1);
                this.addRecipe(d.getKey(), is, extra, (float)(AEConfig.instance().getOreDoublePercentage() / 100.0), 8);
                continue;
            }
            this.addRecipe(d.getKey(), is, 8);
        }
        for (Map.Entry<ItemStack, String> d : this.ingots.entrySet()) {
            if (!name.equals(d.getValue())) continue;
            this.addRecipe(d.getKey(), item, 4);
        }
    }

    private void log(String o, Object ... params) {
        AELog.grinder(o, params);
    }

    private static class CacheKey {
        private final Item item;
        private final int damage;

        CacheKey(ItemStack input) {
            Preconditions.checkNotNull((Object)input);
            Preconditions.checkNotNull((Object)input.func_77973_b());
            this.item = input.func_77973_b();
            this.damage = input.func_77952_i();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.damage;
            result = 31 * result + (this.item == null ? 0 : this.item.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.damage != other.damage) {
                return false;
            }
            return !(this.item == null ? other.item != null : this.item != other.item);
        }
    }
}

