/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.slot;

import appeng.api.config.Actionable;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.container.ContainerNull;
import appeng.container.slot.AppEngCraftingSlot;
import appeng.helpers.IContainerCraftingPacket;
import appeng.helpers.InventoryAction;
import appeng.items.storage.ItemViewCell;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.AdaptorPlayerHand;
import appeng.util.item.AEItemStack;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;

public class SlotCraftingTerm
extends AppEngCraftingSlot {
    private final IInventory craftInv;
    private final IInventory pattern;
    private final BaseActionSource mySrc;
    private final IEnergySource energySrc;
    private final IStorageMonitorable storage;
    private final IContainerCraftingPacket container;

    public SlotCraftingTerm(EntityPlayer player, BaseActionSource mySrc, IEnergySource energySrc, IStorageMonitorable storage, IInventory cMatrix, IInventory secondMatrix, IInventory output, int x, int y, IContainerCraftingPacket ccp) {
        super(player, cMatrix, output, 0, x, y);
        this.energySrc = energySrc;
        this.storage = storage;
        this.mySrc = mySrc;
        this.pattern = cMatrix;
        this.craftInv = secondMatrix;
        this.container = ccp;
    }

    public IInventory getCraftingMatrix() {
        return this.craftInv;
    }

    @Override
    public boolean func_82869_a(EntityPlayer par1EntityPlayer) {
        return false;
    }

    @Override
    public ItemStack func_190901_a(EntityPlayer p, ItemStack is) {
        return is;
    }

    public void doClick(InventoryAction action, EntityPlayer who) {
        if (this.func_75211_c().func_190926_b()) {
            return;
        }
        if (Platform.isClient()) {
            return;
        }
        IMEMonitor<IAEItemStack> inv = this.storage.getItemInventory();
        int howManyPerCraft = this.func_75211_c().func_190916_E();
        int maxTimesToCraft = 0;
        InventoryAdaptor ia = null;
        if (action == InventoryAction.CRAFT_SHIFT) {
            ia = InventoryAdaptor.getAdaptor(who, null);
            maxTimesToCraft = (int)Math.floor((double)this.func_75211_c().func_77976_d() / (double)howManyPerCraft);
        } else if (action == InventoryAction.CRAFT_STACK) {
            ia = new AdaptorPlayerHand(who);
            maxTimesToCraft = (int)Math.floor((double)this.func_75211_c().func_77976_d() / (double)howManyPerCraft);
        } else {
            ia = new AdaptorPlayerHand(who);
            maxTimesToCraft = 1;
        }
        maxTimesToCraft = this.capCraftingAttempts(maxTimesToCraft);
        if (ia == null) {
            return;
        }
        ItemStack rs = Platform.cloneItemStack(this.func_75211_c());
        if (rs.func_190926_b()) {
            return;
        }
        for (int x = 0; x < maxTimesToCraft; ++x) {
            IItemList<IAEItemStack> all;
            ItemStack extra;
            if (!ia.simulateAdd(rs).func_190926_b() || (extra = ia.addItems(this.craftItem(who, rs, inv, all = inv.getStorageList()))).func_190926_b()) continue;
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            drops.add(extra);
            Platform.spawnDrops(who.field_70170_p, new BlockPos((int)who.field_70165_t, (int)who.field_70163_u, (int)who.field_70161_v), drops);
            return;
        }
    }

    private int capCraftingAttempts(int maxTimesToCraft) {
        return maxTimesToCraft;
    }

    private ItemStack craftItem(EntityPlayer p, ItemStack request, IMEMonitor<IAEItemStack> inv, IItemList all) {
        ItemStack is = this.func_75211_c();
        if (!is.func_190926_b() && Platform.itemComparisons().isEqualItem(request, is)) {
            NonNullList set = NonNullList.func_191197_a((int)this.getPattern().func_70302_i_(), (Object)ItemStack.field_190927_a);
            if (Platform.isServer()) {
                InventoryCrafting ic = new InventoryCrafting((Container)new ContainerNull(), 3, 3);
                for (int x = 0; x < 9; ++x) {
                    ic.func_70299_a(x, this.getPattern().func_70301_a(x));
                }
                IRecipe r = Platform.findMatchingRecipe(ic, p.field_70170_p);
                if (r == null) {
                    Item target = request.func_77973_b();
                    if (target.func_77645_m() && target.isRepairable()) {
                        boolean isBad = false;
                        for (int x = 0; x < ic.func_70302_i_(); ++x) {
                            ItemStack pis = ic.func_70301_a(x);
                            if (pis.func_190926_b() || pis.func_77973_b() == target) continue;
                            isBad = true;
                        }
                        if (!isBad) {
                            super.func_190901_a(p, is);
                            p.field_71070_bA.func_75130_a(this.craftInv);
                            return request;
                        }
                    }
                    return ItemStack.field_190927_a;
                }
                is = r.func_77572_b(ic);
                if (inv != null) {
                    for (int x = 0; x < this.getPattern().func_70302_i_(); ++x) {
                        if (this.getPattern().func_70301_a(x).func_190926_b()) continue;
                        set.set(x, (Object)Platform.extractItemsByRecipe(this.energySrc, this.mySrc, inv, p.field_70170_p, r, is, ic, this.getPattern().func_70301_a(x), x, all, Actionable.MODULATE, ItemViewCell.createFilter(this.container.getViewCells())));
                        ic.func_70299_a(x, (ItemStack)set.get(x));
                    }
                }
            }
            if (this.preCraft(p, inv, (NonNullList<ItemStack>)set, is)) {
                this.makeItem(p, is);
                this.postCraft(p, inv, (NonNullList<ItemStack>)set, is);
            }
            p.field_71070_bA.func_75130_a(this.craftInv);
            return is;
        }
        return ItemStack.field_190927_a;
    }

    private boolean preCraft(EntityPlayer p, IMEMonitor<IAEItemStack> inv, NonNullList<ItemStack> set, ItemStack result) {
        return true;
    }

    private void makeItem(EntityPlayer p, ItemStack is) {
        super.func_190901_a(p, is);
    }

    private void postCraft(EntityPlayer p, IMEMonitor<IAEItemStack> inv, NonNullList<ItemStack> set, ItemStack result) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (Platform.isServer()) {
            for (int x = 0; x < this.craftInv.func_70302_i_(); ++x) {
                IAEItemStack fail;
                if (this.craftInv.func_70301_a(x).func_190926_b()) {
                    this.craftInv.func_70299_a(x, (ItemStack)set.get(x));
                    continue;
                }
                if (((ItemStack)set.get(x)).func_190926_b() || (fail = (IAEItemStack)inv.injectItems(AEItemStack.create((ItemStack)set.get(x)), Actionable.MODULATE, this.mySrc)) == null) continue;
                drops.add(fail.getItemStack());
            }
        }
        if (drops.size() > 0) {
            Platform.spawnDrops(p.field_70170_p, new BlockPos((int)p.field_70165_t, (int)p.field_70163_u, (int)p.field_70161_v), drops);
        }
    }

    IInventory getPattern() {
        return this.pattern;
    }
}

