/*
 * Decompiled with CFR 0.152.
 */
package appeng.block;

import appeng.api.util.IOrientable;
import appeng.api.util.IOrientableBlock;
import appeng.block.AEBaseBlock;
import appeng.block.AEBaseTileBlock;
import appeng.block.misc.BlockLightDetector;
import appeng.block.misc.BlockSkyCompass;
import appeng.block.networking.BlockWireless;
import appeng.me.helpers.IGridProxyable;
import appeng.tile.AEBaseTile;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AEBaseItemBlock
extends ItemBlock {
    private final AEBaseBlock blockType;

    public AEBaseItemBlock(Block id) {
        super(id);
        this.blockType = (AEBaseBlock)id;
        this.field_77787_bX = this.blockType.hasSubtypes();
    }

    public int func_77647_b(int dmg) {
        if (this.field_77787_bX) {
            return dmg;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public final void func_77624_a(ItemStack itemStack, EntityPlayer player, List toolTip, boolean advancedTooltips) {
        this.addCheckedInformation(itemStack, player, toolTip, advancedTooltips);
    }

    @SideOnly(value=Side.CLIENT)
    public void addCheckedInformation(ItemStack itemStack, EntityPlayer player, List<String> toolTip, boolean advancedToolTips) {
        this.blockType.func_190948_a(itemStack, player, toolTip, advancedToolTips);
    }

    public boolean isBookEnchantable(ItemStack itemstack1, ItemStack itemstack2) {
        return false;
    }

    public String func_77667_c(ItemStack is) {
        return this.blockType.getUnlocalizedName(is);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World w, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        EnumFacing up = null;
        EnumFacing forward = null;
        if (this.blockType instanceof AEBaseTileBlock) {
            if (this.blockType instanceof BlockLightDetector) {
                up = side;
                forward = up == EnumFacing.UP || up == EnumFacing.DOWN ? EnumFacing.SOUTH : EnumFacing.UP;
            } else if (this.blockType instanceof BlockWireless || this.blockType instanceof BlockSkyCompass) {
                forward = side;
                up = forward == EnumFacing.UP || forward == EnumFacing.DOWN ? EnumFacing.SOUTH : EnumFacing.UP;
            } else {
                up = EnumFacing.UP;
                byte rotation = (byte)(MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 2.5)) & 3);
                switch (rotation) {
                    default: {
                        forward = EnumFacing.SOUTH;
                        break;
                    }
                    case 1: {
                        forward = EnumFacing.WEST;
                        break;
                    }
                    case 2: {
                        forward = EnumFacing.NORTH;
                        break;
                    }
                    case 3: {
                        forward = EnumFacing.EAST;
                    }
                }
                if (player.field_70125_A > 65.0f) {
                    up = forward.func_176734_d();
                    forward = EnumFacing.UP;
                } else if (player.field_70125_A < -65.0f) {
                    up = forward.func_176734_d();
                    forward = EnumFacing.DOWN;
                }
            }
        }
        IOrientable ori = null;
        if (this.blockType instanceof IOrientableBlock) {
            ori = ((IOrientableBlock)((Object)this.blockType)).getOrientable((IBlockAccess)w, pos);
            up = side;
            forward = EnumFacing.SOUTH;
            if (up.func_96559_d() == 0) {
                forward = EnumFacing.UP;
            }
        }
        if (!this.blockType.isValidOrientation(w, pos, forward, up)) {
            return false;
        }
        if (super.placeBlockAt(stack, player, w, pos, side, hitX, hitY, hitZ, newState)) {
            if (this.blockType instanceof AEBaseTileBlock && !(this.blockType instanceof BlockLightDetector)) {
                Object tile = ((AEBaseTileBlock)this.blockType).getTileEntity((IBlockAccess)w, pos);
                ori = tile;
                if (tile == null) {
                    return true;
                }
                if (ori.canBeRotated() && !this.blockType.hasCustomRotation()) {
                    ori.setOrientation(forward, up);
                }
                if (tile instanceof IGridProxyable) {
                    ((IGridProxyable)tile).getProxy().setOwner(player);
                }
                ((AEBaseTile)tile).onPlacement(stack, player, side);
            } else if (this.blockType instanceof IOrientableBlock) {
                ori.setOrientation(forward, up);
            }
            return true;
        }
        return false;
    }
}

