/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.plugin.crafttweaker.RemovalByKind;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import gnu.trove.list.TIntList;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import wanion.unidict.api.UniDictAPI;
import wanion.unidict.plugin.crafttweaker.UniDictCraftTweakerPlugin;
import wanion.unidict.resource.Resource;

@ZenRegister
@ZenClass(value="mods.unidict.removalByKind")
public abstract class RemovalByKind {
    private static final Map<Class<? extends RemovalByKind>, List<RemovalByKindAction>> RECIPE_REMOVAL_BY_KIND_MAP = new IdentityHashMap<Class<? extends RemovalByKind>, List<RemovalByKindAction>>();

    @ZenMethod
    public static RemovalByKind get(String name) {
        String string = name = name != null ? name.toLowerCase() : null;
        if (!UniDictCraftTweakerPlugin.NAME_REMOVAL_BY_KIND_MAP.containsKey(name)) {
            CraftTweakerAPI.logError((String)("mods.unidict.removalByKind.get(\"" + name + "\") doesn't exists!"));
            return null;
        }
        return UniDictCraftTweakerPlugin.NAME_REMOVAL_BY_KIND_MAP.get(name);
    }

    @ZenMethod
    public abstract void remove(@Nonnull String var1, @Optional String[] var2);

    public abstract void apply(@Nonnull UniDictAPI var1);

    @Nonnull
    protected abstract String getName();

    @Nonnull
    protected abstract String getDescription();

    public final RemovalByKind getInstance() {
        return UniDictCraftTweakerPlugin.getRemovalByKind(this.getClass());
    }

    public String toString() {
        return this.getName().toLowerCase();
    }

    protected final TIntObjectMap<TIntList> getKindsForRemovalHashMap() {
        TIntObjectHashMap kindsForRemoval = new TIntObjectHashMap();
        for (RemovalByKindAction removalByKindAction : this.getRemovalByKindList()) {
            int kind = Resource.getKindFromName(removalByKindAction.kind);
            if (kind <= 0) continue;
            kindsForRemoval.put(kind, (Object)Resource.kindNamesToKindList(removalByKindAction.resourceKindWhiteList));
        }
        return kindsForRemoval;
    }

    private List<RemovalByKindAction> getRemovalByKindList() {
        Class<?> removalByKindClass = this.getClass();
        if (!RECIPE_REMOVAL_BY_KIND_MAP.containsKey(removalByKindClass)) {
            RECIPE_REMOVAL_BY_KIND_MAP.put(removalByKindClass, new ArrayList());
        }
        return RECIPE_REMOVAL_BY_KIND_MAP.get(removalByKindClass);
    }

    protected class RemovalByKindAction
    implements IAction {
        protected final String kind;
        protected final String[] resourceKindWhiteList;

        protected RemovalByKindAction(String kind, String[] resourceKindWhiteList) {
            this.kind = kind;
            this.resourceKindWhiteList = resourceKindWhiteList;
        }

        public void apply() {
            RemovalByKind.this.getRemovalByKindList().add(this);
        }

        public String describe() {
            return RemovalByKind.this.getDescription() + this.kind;
        }
    }
}

