/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.RegEx;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import wanion.lib.common.MetaItem;
import wanion.lib.common.Util;
import wanion.unidict.UniDict;

public final class UniOreDictionary
implements UniDict.IDependency {
    private static Map<String, Integer> nameToId = (Map)Util.getField(OreDictionary.class, (String)"nameToId", null, Map.class);
    private static List<String> idToName = (List)Util.getField(OreDictionary.class, (String)"idToName", null, List.class);
    private static List<List<ItemStack>> idToStack = (List)Util.getField(OreDictionary.class, (String)"idToStack", null, List.class);
    private static List<List<ItemStack>> idToStackUn = (List)Util.getField(OreDictionary.class, (String)"idToStackUn", null, List.class);
    private static Map<Integer, List<Integer>> stackToId = (Map)Util.getField(OreDictionary.class, (String)"stackToId", null, Map.class);
    private final Map<List<ItemStack>, String> entryToName = new IdentityHashMap<List<ItemStack>, String>();
    private final TIntObjectMap<String> stackToName = new TIntObjectHashMap();

    private UniOreDictionary() {
        nameToId.keySet().forEach(name -> {
            Integer oreDictId = nameToId.get(name);
            List<ItemStack> entries = UniOreDictionary.getUn(oreDictId);
            if (entries != null) {
                for (int hash : MetaItem.getArray(entries)) {
                    if (this.stackToName.containsKey(hash)) continue;
                    this.stackToName.put(hash, name);
                }
                this.entryToName.put(entries, (String)name);
            }
        });
    }

    public static List<ItemStack> get(String oreDictName) {
        return UniOreDictionary.get(nameToId.get(oreDictName));
    }

    public static List<ItemStack> get(Integer oreDictId) {
        return UniOreDictionary.checkId(oreDictId) ? idToStack.get(oreDictId) : null;
    }

    public static List<ItemStack> getUn(Integer oreDictId) {
        return UniOreDictionary.checkId(oreDictId) ? idToStackUn.get(oreDictId) : null;
    }

    public static List<ItemStack> getUn(@Nonnull String oreDictName) {
        return idToStackUn.get(nameToId.get(oreDictName));
    }

    public static ItemStack getFirstEntry(String oreDictName) {
        List<ItemStack> oreList = UniOreDictionary.get(oreDictName);
        return oreList != null && !oreDictName.isEmpty() ? oreList.get(0).func_77946_l() : null;
    }

    public static ItemStack getLastEntry(String oreDictName) {
        List<ItemStack> oreList = UniOreDictionary.get(oreDictName);
        return oreList != null && !oreDictName.isEmpty() ? oreList.get(oreList.size() - 1).func_77946_l() : null;
    }

    public static List<ItemStack> get(ItemStack thing) {
        int thingId = MetaItem.get((ItemStack)thing);
        if (stackToId.containsKey(thingId)) {
            return idToStack.get(stackToId.get(thingId).get(0));
        }
        return null;
    }

    public static List<Matcher> getThoseThatMatches(@RegEx String regex) {
        return UniOreDictionary.getThoseThatMatches(Pattern.compile(regex));
    }

    public static List<Matcher> getThoseThatMatches(Pattern pattern) {
        ArrayList<Matcher> matcherList = new ArrayList<Matcher>();
        nameToId.keySet().forEach(name -> {
            Matcher matcher = pattern.matcher((CharSequence)name);
            if (matcher.find()) {
                matcherList.add(matcher);
            }
        });
        return matcherList;
    }

    public static void removeFromElsewhere(String oreDictName) {
        ItemStack mainEntry = UniOreDictionary.getFirstEntry(oreDictName);
        if (mainEntry == null) {
            return;
        }
        int[] ids = OreDictionary.getOreIDs((ItemStack)mainEntry);
        if (ids.length == 0) {
            return;
        }
        int mainEntryHash = MetaItem.get((ItemStack)mainEntry);
        int oreDictId = UniOreDictionary.getId(oreDictName);
        for (int id : ids) {
            List<ItemStack> oreDictEntries;
            if (oreDictId == id || (oreDictEntries = UniOreDictionary.get(id)) == null) continue;
            Iterator<ItemStack> oreDictEntriesIterator = oreDictEntries.iterator();
            while (oreDictEntriesIterator.hasNext()) {
                if (mainEntryHash != MetaItem.get((ItemStack)oreDictEntriesIterator.next())) continue;
                oreDictEntriesIterator.remove();
            }
        }
    }

    public static Integer getId(String oreDictName) {
        return nameToId.get(oreDictName);
    }

    private static String getName(Integer oreDictId) {
        return idToName.get(oreDictId);
    }

    private static boolean checkId(Integer oreDictId) {
        return oreDictId != null && oreDictId <= idToStack.size();
    }

    public String getName(Object thing) {
        if (thing instanceof ItemStack) {
            return (String)this.stackToName.get(MetaItem.get((ItemStack)((ItemStack)thing)));
        }
        if (thing instanceof List) {
            return this.entryToName.get(thing);
        }
        return null;
    }
}

