/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item.tool;

import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.item.ItemMod;
import vazkii.arl.item.ItemModSword;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.internal.TooltipHelper;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.item.ItemCAD;
import vazkii.psi.common.item.base.IPsiItem;
import vazkii.psi.common.item.tool.IPsimetalTool;

public class ItemPsimetalSword
extends ItemModSword
implements IPsimetalTool,
IPsiItem {
    public ItemPsimetalSword() {
        super("psimetal_sword", PsiAPI.PSIMETAL_TOOL_MATERIAL, new String[0]);
    }

    public boolean func_77644_a(ItemStack itemstack, EntityLivingBase target, @Nonnull EntityLivingBase attacker) {
        super.func_77644_a(itemstack, target, attacker);
        if (this.isEnabled(itemstack) && attacker instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)attacker;
            PlayerDataHandler.PlayerData data = PlayerDataHandler.get(player);
            ItemStack playerCad = PsiAPI.getPlayerCAD(player);
            if (!playerCad.func_190926_b()) {
                ItemStack bullet = this.getBulletInSocket(itemstack, this.getSelectedSlot(itemstack));
                ItemCAD.cast(player.func_130014_f_(), player, data, bullet, playerCad, 5, 10, 0.05f, context -> {
                    context.attackedEntity = target;
                    context.tool = itemstack;
                });
            }
        }
        return true;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap modifiers = super.getAttributeModifiers(slot, stack);
        if (!this.isEnabled(stack)) {
            modifiers.removeAll((Object)SharedMonsterAttributes.field_111264_e.func_111108_a());
        }
        return modifiers;
    }

    public void setDamage(ItemStack stack, int damage) {
        if (damage > stack.func_77958_k()) {
            damage = stack.func_77952_i();
        }
        super.setDamage(stack, damage);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (!this.isEnabled(stack)) {
            return 1.0f;
        }
        return super.func_150893_a(stack, state);
    }

    @Nonnull
    public String func_77667_c(ItemStack stack) {
        String name = super.func_77667_c(stack);
        if (!this.isEnabled(stack)) {
            name = name + ".broken";
        }
        return name;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        IPsimetalTool.regen(stack, entityIn, isSelected);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        String componentName = ItemMod.local((String)ISocketable.getSocketedItemName(stack, "psimisc.none"));
        TooltipHelper.addToTooltip(tooltip, "psimisc.spellSelected", componentName);
    }

    public boolean func_82789_a(ItemStack thisStack, @Nonnull ItemStack material) {
        return IPsimetalTool.isRepairableBy(material) || super.func_82789_a(thisStack, material);
    }

    @Override
    public boolean requiresSneakForSpellSet(ItemStack stack) {
        return false;
    }
}

