/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.core.handler.capability;

import java.util.concurrent.Callable;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.psi.api.cad.ICADData;
import vazkii.psi.api.cad.IPsiBarDisplay;
import vazkii.psi.api.cad.IShowPsiBar;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.cad.ISocketableCapability;
import vazkii.psi.api.spell.ISpellAcceptor;
import vazkii.psi.api.spell.ISpellImmune;
import vazkii.psi.api.spell.ISpellSettable;
import vazkii.psi.api.spell.detonator.IDetonationHandler;
import vazkii.psi.common.core.handler.capability.CADData;
import vazkii.psi.common.core.handler.capability.SocketWheel;
import vazkii.psi.common.core.handler.capability.SpellHolder;
import vazkii.psi.common.core.handler.capability.wrappers.AcceptorWrapper;
import vazkii.psi.common.core.handler.capability.wrappers.PsiBarWrapper;
import vazkii.psi.common.core.handler.capability.wrappers.SimpleProvider;
import vazkii.psi.common.core.handler.capability.wrappers.SocketWrapper;

@Mod.EventBusSubscriber(modid="psi")
public class CapabilityHandler {
    private static final ResourceLocation SOCKET = new ResourceLocation("psi", "socketable");
    private static final ResourceLocation ACCEPTOR = new ResourceLocation("psi", "spell");
    private static final ResourceLocation PSI_BAR = new ResourceLocation("psi", "bar");
    private static final ResourceLocation SPELL_IMMUNE = new ResourceLocation("psi", "immune");
    private static final ResourceLocation DETONATOR = new ResourceLocation("psi", "detonator");

    public static void register() {
        CapabilityHandler.register(ICADData.class, CADData::new);
        CapabilityHandler.register(ISocketableCapability.class, SocketWheel::new);
        CapabilityHandler.register(ISpellAcceptor.class, SpellHolder::new);
        CapabilityHandler.registerSingleDefault(IDetonationHandler.class, () -> {});
        CapabilityHandler.registerSingleDefault(IPsiBarDisplay.class, data -> false);
        CapabilityHandler.registerSingleDefault(ISpellImmune.class, () -> false);
    }

    private static <T> void registerSingleDefault(Class<T> clazz, T provided) {
        CapabilityHandler.register(clazz, () -> provided);
    }

    private static <T> void register(Class<T> clazz, Callable<T> provider) {
        CapabilityManager.INSTANCE.register(clazz, new CapabilityFactory(), provider);
    }

    @SubscribeEvent
    public static void attachItemCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        Item item = ((ItemStack)event.getObject()).func_77973_b();
        if (item instanceof ISocketable) {
            event.addCapability(SOCKET, (ICapabilityProvider)new SocketWrapper((ItemStack)event.getObject()));
        }
        if (((ItemStack)event.getObject()).func_77973_b() instanceof IShowPsiBar) {
            event.addCapability(PSI_BAR, (ICapabilityProvider)new PsiBarWrapper((ItemStack)event.getObject()));
        }
        if (((ItemStack)event.getObject()).func_77973_b() instanceof ISpellSettable) {
            event.addCapability(ACCEPTOR, (ICapabilityProvider)new AcceptorWrapper((ItemStack)event.getObject()));
        }
    }

    @SubscribeEvent
    public static void attachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof ISpellImmune) {
            event.addCapability(SPELL_IMMUNE, new SimpleProvider<ISpellImmune>(ISpellImmune.CAPABILITY, (ISpellImmune)event.getObject()));
        }
        if (event.getObject() instanceof IDetonationHandler) {
            event.addCapability(DETONATOR, new SimpleProvider<IDetonationHandler>(IDetonationHandler.CAPABILITY, (IDetonationHandler)event.getObject()));
        }
    }

    private static class CapabilityFactory<T>
    implements Capability.IStorage<T> {
        private CapabilityFactory() {
        }

        public NBTBase writeNBT(Capability<T> capability, T instance, EnumFacing side) {
            if (instance instanceof INBTSerializable) {
                return ((INBTSerializable)instance).serializeNBT();
            }
            return null;
        }

        public void readNBT(Capability<T> capability, T instance, EnumFacing side, NBTBase nbt) {
            if (nbt instanceof NBTTagCompound) {
                ((INBTSerializable)instance).deserializeNBT(nbt);
            }
        }
    }
}

