/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.api.spell.detonator;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fml.common.eventhandler.Event;
import vazkii.psi.api.spell.detonator.DetonationEvent;

public interface IDetonationHandler {
    @CapabilityInject(value=IDetonationHandler.class)
    public static final Capability<IDetonationHandler> CAPABILITY = null;

    public static boolean canBeDetonated(Entity entity) {
        return entity.hasCapability(CAPABILITY, null);
    }

    public static IDetonationHandler detonator(Entity entity) {
        return (IDetonationHandler)entity.getCapability(CAPABILITY, null);
    }

    public static void performDetonation(World world, EntityPlayer player) {
        IDetonationHandler.performDetonation(world, player, (Entity)player, 32.0, e -> true);
    }

    public static void performDetonation(World world, EntityPlayer player, double range) {
        IDetonationHandler.performDetonation(world, player, (Entity)player, range, e -> true);
    }

    public static void performDetonation(World world, EntityPlayer player, Predicate<Entity> filter) {
        IDetonationHandler.performDetonation(world, player, (Entity)player, 32.0, filter);
    }

    public static void performDetonation(World world, EntityPlayer player, double range, Predicate<Entity> filter) {
        IDetonationHandler.performDetonation(world, player, (Entity)player, range, filter);
    }

    public static void performDetonation(World world, EntityPlayer player, Entity center) {
        IDetonationHandler.performDetonation(world, player, center, 32.0, e -> true);
    }

    public static void performDetonation(World world, EntityPlayer player, Entity center, double range) {
        IDetonationHandler.performDetonation(world, player, center, range, e -> true);
    }

    public static void performDetonation(World world, EntityPlayer player, Entity center, Predicate<Entity> filter) {
        IDetonationHandler.performDetonation(world, player, center, 32.0, filter);
    }

    public static void performDetonation(World world, EntityPlayer player, Entity center, double range, Predicate<Entity> filter) {
        List charges = world.func_175647_a(Entity.class, center.func_174813_aQ().func_186662_g(range), entity -> {
            if (entity == null || !IDetonationHandler.canBeDetonated(entity)) {
                return false;
            }
            IDetonationHandler detonator = IDetonationHandler.detonator(entity);
            Vec3d locus = detonator.objectLocus();
            if (locus == null || locus.func_186679_c(center.field_70165_t, center.field_70163_u, center.field_70161_v) > range * range) {
                return false;
            }
            return filter == null || filter.test((Entity)entity);
        });
        List<IDetonationHandler> handlers = charges.stream().map(IDetonationHandler::detonator).collect(Collectors.toList());
        if (!MinecraftForge.EVENT_BUS.post((Event)new DetonationEvent(player, center, range, handlers)) && !handlers.isEmpty()) {
            for (IDetonationHandler handler : handlers) {
                handler.detonate();
            }
        }
    }

    default public Vec3d objectLocus() {
        return null;
    }

    public void detonate();
}

