/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick.block;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;
import vazkii.psi.common.spell.trick.block.PieceTrickBreakBlock;

public class PieceTrickCollapseBlock
extends PieceTrick {
    SpellParam position;

    public PieceTrickCollapseBlock(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", SpellParam.BLUE, false, false);
        this.addParam(this.position);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        meta.addStat(EnumSpellStat.POTENCY, 80);
        meta.addStat(EnumSpellStat.COST, 125);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Vector3 positionVal = (Vector3)this.getParamValue(context, this.position);
        if (positionVal == null) {
            throw new SpellRuntimeException("psi.spellerror.nullvector");
        }
        if (!context.isInRadius(positionVal)) {
            throw new SpellRuntimeException("psi.spellerror.outsideradius");
        }
        ItemStack tool = context.tool;
        if (tool.func_190926_b()) {
            tool = PsiAPI.getPlayerCAD(context.caster);
        }
        World world = context.caster.func_130014_f_();
        BlockPos pos = positionVal.toBlockPos();
        BlockPos posDown = pos.func_177977_b();
        IBlockState state = world.func_180495_p(pos);
        IBlockState stateDown = world.func_180495_p(posDown);
        Block block = state.func_177230_c();
        Block blockBelow = stateDown.func_177230_c();
        if (!world.func_175660_a(context.caster, pos)) {
            return null;
        }
        if (blockBelow.isAir(stateDown, (IBlockAccess)world, posDown) && state.func_185887_b(world, pos) != -1.0f && PieceTrickBreakBlock.canHarvestBlock(block, context.caster, world, pos, tool) && world.func_175625_s(pos) == null && block.canSilkHarvest(world, pos, state, context.caster)) {
            BlockEvent.BreakEvent event = PieceTrickBreakBlock.createBreakEvent(state, context.caster, world, pos, tool);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                return null;
            }
            if (state.func_177230_c() == Blocks.field_150439_ay) {
                state = Blocks.field_150450_ax.func_176223_P();
                world.func_175656_a(pos, state);
            }
            EntityFallingBlock falling = new EntityFallingBlock(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, state);
            world.func_72838_d((Entity)falling);
        }
        return null;
    }
}

