/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item.tool;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.spell.ISpellAcceptor;
import vazkii.psi.api.spell.ISpellSettable;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.item.ItemCAD;

public interface IPsimetalTool
extends ISocketable,
ISpellSettable {
    public static final String TAG_REGEN_TIME = "regenTime";
    public static final String TAG_BULLET_PREFIX = "bullet";
    public static final String TAG_SELECTED_SLOT = "selectedSlot";

    @Override
    default public boolean isSocketSlotAvailable(ItemStack stack, int slot) {
        return slot < 3;
    }

    @Override
    default public boolean showSlotInRadialMenu(ItemStack stack, int slot) {
        return this.isSocketSlotAvailable(stack, slot - 1);
    }

    @Override
    default public ItemStack getBulletInSocket(ItemStack stack, int slot) {
        String name = TAG_BULLET_PREFIX + slot;
        NBTTagCompound cmp = ItemNBTHelper.getCompound((ItemStack)stack, (String)name, (boolean)true);
        if (cmp == null) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack(cmp);
    }

    @Override
    default public void setBulletInSocket(ItemStack stack, int slot, ItemStack bullet) {
        String name = TAG_BULLET_PREFIX + slot;
        NBTTagCompound cmp = new NBTTagCompound();
        if (!bullet.func_190926_b()) {
            bullet.func_77955_b(cmp);
        }
        ItemNBTHelper.setCompound((ItemStack)stack, (String)name, (NBTTagCompound)cmp);
    }

    @Override
    default public int getSelectedSlot(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_SELECTED_SLOT, (int)0);
    }

    @Override
    default public void setSelectedSlot(ItemStack stack, int slot) {
        ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_SELECTED_SLOT, (int)slot);
    }

    @Override
    default public void setSpell(EntityPlayer player, ItemStack stack, Spell spell) {
        int slot = this.getSelectedSlot(stack);
        ItemStack bullet = this.getBulletInSocket(stack, slot);
        if (!bullet.func_190926_b() && ISpellAcceptor.isAcceptor(bullet)) {
            ISpellAcceptor.acceptor(bullet).setSpell(player, spell);
            this.setBulletInSocket(stack, slot, bullet);
        }
    }

    default public void castOnBlockBreak(ItemStack itemstack, EntityPlayer player) {
        if (!this.isEnabled(itemstack)) {
            return;
        }
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get(player);
        ItemStack playerCad = PsiAPI.getPlayerCAD(player);
        if (!playerCad.func_190926_b()) {
            ItemStack bullet = this.getBulletInSocket(itemstack, this.getSelectedSlot(itemstack));
            ItemCAD.cast(player.func_130014_f_(), player, data, bullet, playerCad, 5, 10, 0.05f, context -> {
                context.tool = itemstack;
                context.positionBroken = IPsimetalTool.raytraceFromEntity(player.func_130014_f_(), (Entity)player, false, player.func_110140_aT().func_111151_a(EntityPlayer.REACH_DISTANCE).func_111126_e());
            });
        }
    }

    public static boolean isRepairableBy(ItemStack stack) {
        return ArrayUtils.contains((int[])OreDictionary.getOreIDs((ItemStack)stack), (int)OreDictionary.getOreID((String)"ingotPsi"));
    }

    public static RayTraceResult raytraceFromEntity(World world, Entity player, boolean stopOnLiquid, double range) {
        float scale = 1.0f;
        float pitch = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * scale;
        float yaw = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * scale;
        double posX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)scale;
        double posY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)scale;
        if (player instanceof EntityPlayer) {
            posY += (double)((EntityPlayer)player).eyeHeight;
        }
        double posZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)scale;
        Vec3d rayPos = new Vec3d(posX, posY, posZ);
        float zYaw = -MathHelper.func_76134_b((float)(yaw * (float)Math.PI / 180.0f));
        float xYaw = MathHelper.func_76126_a((float)(yaw * (float)Math.PI / 180.0f));
        float pitchMod = -MathHelper.func_76134_b((float)(pitch * (float)Math.PI / 180.0f));
        float azimuth = -MathHelper.func_76126_a((float)(pitch * (float)Math.PI / 180.0f));
        float xLen = xYaw * pitchMod;
        float yLen = zYaw * pitchMod;
        Vec3d end = rayPos.func_72441_c((double)xLen * range, (double)azimuth * range, (double)yLen * range);
        return world.func_72901_a(rayPos, end, stopOnLiquid);
    }

    public static void regen(ItemStack stack, Entity entityIn, boolean isSelected) {
        if (entityIn instanceof EntityPlayer && stack.func_77952_i() > 0 && !isSelected) {
            EntityPlayer player = (EntityPlayer)entityIn;
            PlayerDataHandler.PlayerData data = PlayerDataHandler.get(player);
            int regenTime = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_REGEN_TIME, (int)0);
            if (!data.overflowed && regenTime % 16 == 0 && (float)data.getAvailablePsi() / (float)data.getTotalPsi() > 0.5f) {
                data.deductPsi(150, 0, true);
                stack.func_77964_b(stack.func_77952_i() - 1);
            }
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_REGEN_TIME, (int)(regenTime + 1));
        }
    }

    default public boolean isEnabled(ItemStack stack) {
        return stack.func_77952_i() < stack.func_77958_k();
    }
}

