/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.api.spell;

import vazkii.psi.api.internal.TooltipHelper;
import vazkii.psi.api.spell.EnumPieceType;
import vazkii.psi.api.spell.SpellPiece;

public abstract class SpellParam {
    public static int RED = 0xD22A2A;
    public static int GREEN = 4117034;
    public static int BLUE = 2774482;
    public static int PURPLE = 7678674;
    public static int CYAN = 2805970;
    public static int YELLOW = 13814826;
    public static int GRAY = 0x767676;
    public static int BROWN = 0x664000;
    public static final String PSI_PREFIX = "psi.spellparam.";
    public static final String GENERIC_NAME_TARGET = "psi.spellparam.target";
    public static final String GENERIC_NAME_NUMBER = "psi.spellparam.number";
    public static final String GENERIC_NAME_NUMBER1 = "psi.spellparam.number1";
    public static final String GENERIC_NAME_NUMBER2 = "psi.spellparam.number2";
    public static final String GENERIC_NAME_NUMBER3 = "psi.spellparam.number3";
    public static final String GENERIC_NAME_NUMBER4 = "psi.spellparam.number4";
    public static final String GENERIC_NAME_VECTOR1 = "psi.spellparam.vector1";
    public static final String GENERIC_NAME_VECTOR2 = "psi.spellparam.vector2";
    public static final String GENERIC_NAME_VECTOR3 = "psi.spellparam.vector3";
    public static final String GENERIC_NAME_VECTOR4 = "psi.spellparam.vector4";
    public static final String GENERIC_NAME_POSITION = "psi.spellparam.position";
    public static final String GENERIC_NAME_MIN = "psi.spellparam.min";
    public static final String GENERIC_NAME_MAX = "psi.spellparam.max";
    public static final String GENERIC_NAME_POWER = "psi.spellparam.power";
    public static final String GENERIC_NAME_X = "psi.spellparam.x";
    public static final String GENERIC_NAME_Y = "psi.spellparam.y";
    public static final String GENERIC_NAME_Z = "psi.spellparam.z";
    public static final String GENERIC_NAME_RADIUS = "psi.spellparam.radius";
    public static final String GENERIC_NAME_DISTANCE = "psi.spellparam.distance";
    public static final String GENERIC_NAME_TIME = "psi.spellparam.time";
    public static final String GENERIC_NAME_BASE = "psi.spellparam.base";
    public static final String GENERIC_NAME_RAY = "psi.spellparam.ray";
    public final String name;
    public final int color;
    public final boolean canDisable;

    public SpellParam(String name, int color, boolean canDisable) {
        this.name = name;
        this.color = color;
        this.canDisable = canDisable;
    }

    protected abstract Class<?> getRequiredType();

    protected boolean requiresConstant() {
        return false;
    }

    public String getRequiredTypeString() {
        Class<?> evalType = this.getRequiredType();
        String evalStr = evalType.getSimpleName();
        String s = TooltipHelper.local("psi.datatype." + evalStr);
        if (this.requiresConstant()) {
            s = s + " " + TooltipHelper.local("psimisc.constant");
        }
        return s;
    }

    public boolean canAccept(SpellPiece piece) {
        return !(this.getRequiredType() != Any.class && !this.getRequiredType().isAssignableFrom(piece.getEvaluationType()) || this.requiresConstant() && piece.getPieceType() != EnumPieceType.CONSTANT);
    }

    public static class Any {
    }

    public static enum Side {
        OFF(0, 0, 238, 0),
        TOP(0, -1, 222, 8),
        BOTTOM(0, 1, 230, 8),
        LEFT(-1, 0, 230, 0),
        RIGHT(1, 0, 222, 0);

        public static final Side[] DIRECTIONS;
        public final int offx;
        public final int offy;
        public final int u;
        public final int v;

        private Side(int offx, int offy, int u, int v) {
            this.offx = offx;
            this.offy = offy;
            this.u = u;
            this.v = v;
        }

        public boolean isEnabled() {
            return this != OFF;
        }

        public int asInt() {
            return this.ordinal();
        }

        public static Side fromInt(int i) {
            return ((Side[])Side.class.getEnumConstants())[i];
        }

        public Side getOpposite() {
            return this.mapSides(BOTTOM, TOP, RIGHT, LEFT);
        }

        public Side mirrorVertical() {
            return this.mapSides(BOTTOM, TOP, LEFT, RIGHT);
        }

        public Side rotateCW() {
            return this.mapSides(LEFT, RIGHT, BOTTOM, TOP);
        }

        public Side rotateCCW() {
            return this.mapSides(RIGHT, LEFT, TOP, BOTTOM);
        }

        private Side mapSides(Side whenUp, Side whenDown, Side whenL, Side whenR) {
            switch (this) {
                case TOP: {
                    return whenUp;
                }
                case BOTTOM: {
                    return whenDown;
                }
                case LEFT: {
                    return whenL;
                }
                case RIGHT: {
                    return whenR;
                }
            }
            return OFF;
        }

        static {
            DIRECTIONS = new Side[]{TOP, BOTTOM, LEFT, RIGHT};
        }
    }
}

