/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.api.spell;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import vazkii.psi.api.cad.EnumCADStat;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.spell.EnumSpellStat;

public final class SpellMetadata {
    public final Map<EnumSpellStat, Integer> stats = new EnumMap<EnumSpellStat, Integer>(EnumSpellStat.class);
    public boolean errorsSuppressed = false;

    public SpellMetadata() {
        for (EnumSpellStat stat : (EnumSpellStat[])EnumSpellStat.class.getEnumConstants()) {
            this.stats.put(stat, 0);
        }
    }

    public void addStat(EnumSpellStat stat, int val) {
        int curr = this.stats.get((Object)stat);
        this.setStat(stat, val + curr);
    }

    public void setStat(EnumSpellStat stat, int val) {
        this.stats.put(stat, val);
    }

    public boolean evaluateAgainst(ItemStack stack) {
        if (stack == null || !(stack.func_77973_b() instanceof ICAD)) {
            return false;
        }
        ICAD cad = (ICAD)stack.func_77973_b();
        for (EnumSpellStat stat : this.stats.keySet()) {
            EnumCADStat cadStat = stat.getTarget();
            if (cadStat == null) continue;
            int statVal = this.stats.get((Object)stat);
            int cadVal = cad.getStatValue(stack, cadStat);
            if (cadVal == -1 || cadVal >= statVal) continue;
            return false;
        }
        return true;
    }
}

