/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.planetprogression.network;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.mjr.mjrlegendslib.network.IPacket;
import com.mjr.planetprogression.client.handlers.MainHandlerClient;
import com.mjr.planetprogression.handlers.MainHandlerServer;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetHandler;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;

@ChannelHandler.Sharable
public class PlanetProgressionPacketHandler
extends SimpleChannelInboundHandler<IPacket> {
    private final Map<Side, Map<Integer, Queue<PacketPlayerPair>>> packetMap;
    private static volatile int livePacketCount = 0;

    public PlanetProgressionPacketHandler() {
        HashMap map = Maps.newHashMap();
        for (Side side : Side.values()) {
            ConcurrentHashMap sideMap = new ConcurrentHashMap();
            map.put(side, sideMap);
        }
        this.packetMap = ImmutableMap.copyOf((Map)map);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            MainHandlerClient.addPacketHandler(this);
        }
        MainHandlerServer.addPacketHandler(this);
    }

    public void unload(World world) {
        Side side = world.field_72995_K ? Side.CLIENT : Side.SERVER;
        int dimId = world.field_73011_w.getDimension();
        Queue<PacketPlayerPair> queue = this.getQueue(side, dimId);
        queue.clear();
    }

    public void tick(World world) {
        PacketPlayerPair pair;
        Side side = world.field_72995_K ? Side.CLIENT : Side.SERVER;
        int dimID = world.field_73011_w.getDimension();
        Queue<PacketPlayerPair> queue = this.getQueue(side, dimID);
        while ((pair = queue.poll()) != null) {
            switch (side) {
                case CLIENT: {
                    pair.getPacket().handleClientSide(pair.getPlayer());
                    break;
                }
                case SERVER: {
                    pair.getPacket().handleServerSide(pair.getPlayer());
                }
            }
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, IPacket msg) throws Exception {
        INetHandler netHandler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
        Side side = (Side)ctx.channel().attr(NetworkRegistry.CHANNEL_SOURCE).get();
        EntityPlayer player = GalacticraftCore.proxy.getPlayerFromNetHandler(netHandler);
        if (player == null) {
            return;
        }
        if (side != null) {
            this.getQueue(side, msg.getDimensionID()).add(new PacketPlayerPair(msg, player));
            PlanetProgressionPacketHandler.setLivePacketCount(PlanetProgressionPacketHandler.getLivePacketCount() + 1);
        }
    }

    private Queue<PacketPlayerPair> getQueue(Side side, int dimID) {
        Map<Integer, Queue<PacketPlayerPair>> map = this.packetMap.get(side);
        if (!map.containsKey(dimID)) {
            map.put(dimID, Queues.newConcurrentLinkedQueue());
        }
        return map.get(dimID);
    }

    public static int getLivePacketCount() {
        return livePacketCount;
    }

    public static void setLivePacketCount(int livePacketCount) {
        PlanetProgressionPacketHandler.livePacketCount = livePacketCount;
    }

    private final class PacketPlayerPair {
        private IPacket packet;
        private EntityPlayer player;

        public PacketPlayerPair(IPacket packet, EntityPlayer player) {
            this.packet = packet;
            this.player = player;
        }

        public IPacket getPacket() {
            return this.packet;
        }

        public void setPacket(IPacket packet) {
            this.packet = packet;
        }

        public EntityPlayer getPlayer() {
            return this.player;
        }

        public void setPlayer(EntityPlayer player) {
            this.player = player;
        }
    }
}

