/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.planetprogression.item;

import com.google.common.collect.Lists;
import com.mjr.planetprogression.Config;
import com.mjr.planetprogression.PlanetProgression;
import com.mjr.planetprogression.item.ItemDishKeycard;
import com.mjr.planetprogression.item.ItemSatellite;
import com.mjr.planetprogression.item.ItemSatelliteRocket;
import com.mjr.planetprogression.item.ResearchPaper;
import com.mjr.planetprogression.item.SatelliteModule;
import com.mjr.planetprogression.item.SatelliteModuleBasic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import net.minecraft.item.Item;

public class PlanetProgression_Items {
    public static List<Item> researchPapers = new ArrayList<Item>();
    public static Item satelliteModules;
    public static Item satelliteBasicModule;
    public static Item satelliteBasic;
    public static Item satelliteSurface;
    public static Item satelliteDistance;
    public static Item satelliteAtmosphere;
    public static Item SATELLITE_ROCKET;
    public static Item DISH_KEYCARD;

    public static void init() {
        PlanetProgression_Items.initItems();
        PlanetProgression_Items.registerItems();
    }

    public static void registerItem(Item item, String name) {
        if (item.getRegistryName() == null) {
            item.setRegistryName(name);
        }
        PlanetProgression.itemList.add(item);
    }

    public static void initResearchPaperItems() {
        ArrayList<Object> unReachableResearchPapers = new ArrayList<Object>();
        List<Moon> reachablePlanetsMoons = new ArrayList<Planet>();
        reachablePlanetsMoons.add((Moon)GalacticraftCore.planetOverworld);
        int temp = 0;
        for (Planet planet : GalaxyRegistry.getRegisteredPlanets().values()) {
            if (planet.getReachable()) {
                reachablePlanetsMoons.add((Moon)planet);
                continue;
            }
            unReachableResearchPapers.add(planet);
        }
        for (Moon moon : GalaxyRegistry.getRegisteredMoons().values()) {
            if (moon.getReachable()) {
                reachablePlanetsMoons.add(moon);
                continue;
            }
            unReachableResearchPapers.add(moon);
        }
        Collections.sort(reachablePlanetsMoons, SortType.getTypeFromID(1));
        reachablePlanetsMoons = Lists.reverse(reachablePlanetsMoons);
        researchPapers.add((Item)new ResearchPaper("moon.moon", temp++));
        researchPapers.add((Item)new ResearchPaper("planet.mars", temp++));
        researchPapers.add((Item)new ResearchPaper("planet.venus", temp++));
        researchPapers.add((Item)new ResearchPaper("planet.asteroids", temp++));
        for (CelestialBody celestialBody : reachablePlanetsMoons) {
            researchPapers.add((Item)new ResearchPaper(celestialBody.getUnlocalizedName(), temp++));
        }
        for (CelestialBody celestialBody : unReachableResearchPapers) {
            researchPapers.add((Item)new ResearchPaper(celestialBody.getUnlocalizedName(), temp++));
        }
        ArrayList<String> bodiesExtra = new ArrayList<String>();
        bodiesExtra.add("planet.mercury");
        bodiesExtra.add("planet.jupiter");
        bodiesExtra.add("planet.saturn");
        bodiesExtra.add("planet.uranus");
        bodiesExtra.add("planet.neptune");
        boolean bl = false;
        for (String tempBody : bodiesExtra) {
            boolean bl2;
            if (researchPapers.size() == 0) {
                bl2 = true;
            }
            for (Item paper : researchPapers) {
                if (bl2 || !((ResearchPaper)paper).getBodyName().equalsIgnoreCase(tempBody)) continue;
                bl2 = true;
            }
            if (bl2) continue;
            researchPapers.add((Item)new ResearchPaper(tempBody, temp++));
            bl2 = false;
        }
        for (Item item : researchPapers) {
            System.out.println(((ResearchPaper)item).getBodyName());
        }
    }

    public static void initItems() {
        if (Config.researchMode == 2 || Config.researchMode == 3) {
            SATELLITE_ROCKET = new ItemSatelliteRocket("item_satellite_rocket");
            DISH_KEYCARD = new ItemDishKeycard("dish_keycard");
        }
        if (Config.researchMode == 2) {
            satelliteBasicModule = new SatelliteModuleBasic("satellite_module_basic");
            satelliteBasic = new ItemSatellite("satellite_basic", 0);
        }
        if (Config.researchMode == 3) {
            satelliteModules = new SatelliteModule("satellite_module");
            satelliteSurface = new ItemSatellite("satellite_surface", 1);
            satelliteDistance = new ItemSatellite("satellite_distance", 2);
            satelliteAtmosphere = new ItemSatellite("satellite_atmosphere", 3);
        }
    }

    public static void registerResearchPaperItems() {
        for (Item item : researchPapers) {
            PlanetProgression_Items.registerItem(item, item.func_77658_a().substring(5));
        }
    }

    public static void registerItems() {
        if (Config.researchMode == 2 || Config.researchMode == 3) {
            PlanetProgression_Items.registerItem(SATELLITE_ROCKET, SATELLITE_ROCKET.func_77658_a().substring(5));
            PlanetProgression_Items.registerItem(DISH_KEYCARD, DISH_KEYCARD.func_77658_a().substring(5));
        }
        if (Config.researchMode == 2) {
            PlanetProgression_Items.registerItem(satelliteBasicModule, satelliteBasicModule.func_77658_a().substring(5));
            PlanetProgression_Items.registerItem(satelliteBasic, satelliteBasic.func_77658_a().substring(5));
        }
        if (Config.researchMode == 3) {
            PlanetProgression_Items.registerItem(satelliteModules, satelliteModules.func_77658_a().substring(5));
            PlanetProgression_Items.registerItem(satelliteSurface, satelliteSurface.func_77658_a().substring(5));
            PlanetProgression_Items.registerItem(satelliteDistance, satelliteDistance.func_77658_a().substring(5));
            PlanetProgression_Items.registerItem(satelliteAtmosphere, satelliteAtmosphere.func_77658_a().substring(5));
        }
    }

    static enum SortType implements Comparator<CelestialBody>
    {
        TIER(1){

            @Override
            public int compare(CelestialBody celestial1, CelestialBody celestial2) {
                return Integer.compare(celestial2.getTierRequirement(), celestial1.getTierRequirement());
            }
        };

        protected static final SortType[] values;
        private int id;

        private SortType(int id) {
            this.id = id;
        }

        @Override
        public int compare(CelestialBody celestial1, CelestialBody celestial2) {
            return celestial2.getName().compareTo(celestial1.getName());
        }

        @Nullable
        protected static SortType getTypeFromID(int id) {
            for (SortType type : values) {
                if (type.id != id) continue;
                return type;
            }
            return null;
        }

        static {
            values = SortType.values();
        }
    }
}

