/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.planetprogression.handlers.capabilities;

import com.mjr.planetprogression.data.SatelliteData;
import com.mjr.planetprogression.handlers.capabilities.IStatsCapability;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.UUID;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class StatsCapability
implements IStatsCapability {
    public WeakReference<EntityPlayerMP> player;
    private ArrayList<CelestialBody> unlockedPlanets = new ArrayList();
    private ArrayList<SatelliteData> satellites = new ArrayList();
    public int buildFlags = 0;

    @Override
    public ArrayList<CelestialBody> getUnlockedPlanets() {
        return this.unlockedPlanets;
    }

    @Override
    public void setUnlockedPlanets(ArrayList<CelestialBody> unlockedPlanets) {
        this.unlockedPlanets = unlockedPlanets;
    }

    @Override
    public void addUnlockedPlanets(CelestialBody unlockedPlanet) {
        this.unlockedPlanets.add(unlockedPlanet);
    }

    @Override
    public void saveNBTData(NBTTagCompound nbt) {
        NBTTagCompound nbttagcompound;
        NBTTagList tagList = new NBTTagList();
        for (CelestialBody planet : this.unlockedPlanets) {
            if (planet == null) continue;
            nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74778_a("UnlockedPlanet", planet.getUnlocalizedName());
            tagList.func_74742_a((NBTBase)nbttagcompound);
        }
        nbt.func_74782_a("Planets", (NBTBase)tagList);
        tagList = new NBTTagList();
        for (SatelliteData satellite : this.satellites) {
            if (satellite == null) continue;
            nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74778_a("uuid", satellite.getUuid());
            nbttagcompound.func_74768_a("type", satellite.getType());
            nbttagcompound.func_74768_a("dataAmount", satellite.getDataAmount());
            if (satellite.getCurrentResearchItem() != null) {
                nbttagcompound.func_74782_a("currentResearchItem", (NBTBase)satellite.getCurrentResearchItem().func_77955_b(new NBTTagCompound()));
            }
            tagList.func_74742_a((NBTBase)nbttagcompound);
        }
        nbt.func_74782_a("Satellites", (NBTBase)tagList);
    }

    @Override
    public void loadNBTData(NBTTagCompound nbt) {
        try {
            this.unlockedPlanets = new ArrayList();
            this.satellites = new ArrayList();
            if (this.player.get() != null) {
                int i;
                for (i = 0; i < nbt.func_150295_c("Planets", 10).func_74745_c(); ++i) {
                    this.unlockedPlanets.add(GalaxyRegistry.getCelestialBodyFromUnlocalizedName((String)nbt.func_150295_c("Planets", 10).func_150305_b(i).func_74779_i("UnlockedPlanet")));
                }
                for (i = 0; i < nbt.func_150295_c("Satellites", 10).func_74745_c(); ++i) {
                    NBTTagCompound tag;
                    NBTTagCompound nbttagcompound = nbt.func_150295_c("Satellites", 10).func_150305_b(i);
                    String j = nbttagcompound.func_74779_i("uuid");
                    int k = nbttagcompound.func_74762_e("type");
                    int l = nbttagcompound.func_74762_e("dataAmount");
                    if (j == "") {
                        j = UUID.randomUUID().toString();
                    }
                    this.satellites.add(new SatelliteData(k, j, l, new ItemStack(tag = nbt.func_74775_l("currentResearchItem")).func_77977_a().contains("air") ? null : new ItemStack(tag)));
                }
            }
        }
        catch (Exception e) {
            GCLog.severe((String)("Found error in saved Planet Progression player data for " + ((EntityPlayerMP)this.player.get()).func_146103_bH().getName() + " - this should fix itself next relog."));
            e.printStackTrace();
        }
        GCLog.debug((String)("Finished loading Planet Progression player data for " + ((EntityPlayerMP)this.player.get()).func_146103_bH().getName() + " : " + this.buildFlags));
    }

    @Override
    public void copyFrom(IStatsCapability oldData, boolean keepInv) {
        this.unlockedPlanets = oldData.getUnlockedPlanets();
        this.satellites = oldData.getSatellites();
    }

    @Override
    public WeakReference<EntityPlayerMP> getPlayer() {
        return this.player;
    }

    @Override
    public void setPlayer(WeakReference<EntityPlayerMP> player) {
        this.player = player;
    }

    @Override
    public ArrayList<SatelliteData> getSatellites() {
        return this.satellites;
    }

    @Override
    public void setSatellites(ArrayList<SatelliteData> satellites) {
        this.satellites = satellites;
    }

    @Override
    public void addSatellites(SatelliteData satellites) {
        this.satellites.add(satellites);
    }

    @Override
    public void removeSatellites(SatelliteData satellites) {
        this.satellites.remove(satellites);
    }

    @Override
    public void removeUnlockedPlanets(CelestialBody unlockedPlanet) {
        this.unlockedPlanets.remove(unlockedPlanet);
    }
}

