/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.planetprogression.client.gui.screen;

import com.google.common.collect.Lists;
import com.mjr.planetprogression.client.handlers.capabilities.CapabilityStatsClientHandler;
import com.mjr.planetprogression.client.handlers.capabilities.IStatsClientCapability;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.core.client.gui.screen.GuiCelestialSelection;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.lwjgl.util.vector.Vector3f;

public class CustomGuiCelestialSelection
extends GuiCelestialSelection {
    public CustomGuiCelestialSelection(boolean mapMode, List<CelestialBody> possibleBodies, boolean canCreateStations) {
        super(mapMode, possibleBodies, canCreateStations);
    }

    public void func_73866_w_() {
        Minecraft minecraft = FMLClientHandler.instance().getClient();
        EntityPlayerSP player = minecraft.field_71439_g;
        EntityPlayerSP playerBaseClient = PlayerUtil.getPlayerBaseClientFromPlayer((EntityPlayer)player, (boolean)false);
        IStatsClientCapability stats = null;
        if (player != null) {
            stats = (IStatsClientCapability)playerBaseClient.getCapability(CapabilityStatsClientHandler.PP_STATS_CLIENT_CAPABILITY, null);
        }
        this.celestialBodyTicks.clear();
        this.bodiesToRender.clear();
        for (SolarSystem star : GalaxyRegistry.getRegisteredSolarSystems().values()) {
            this.celestialBodyTicks.put(star.getMainStar(), 0);
        }
        for (Planet planet : GalaxyRegistry.getRegisteredPlanets().values()) {
            if (!stats.getUnlockedPlanets().contains(planet)) continue;
            this.celestialBodyTicks.put(planet, 0);
            this.bodiesToRender.add(planet);
        }
        for (Moon moon : GalaxyRegistry.getRegisteredMoons().values()) {
            if (!stats.getUnlockedPlanets().contains(moon.getParentPlanet()) || !stats.getUnlockedPlanets().contains(moon)) continue;
            this.celestialBodyTicks.put(moon, 0);
            this.bodiesToRender.add(moon);
        }
        for (Satellite satellite : GalaxyRegistry.getRegisteredSatellites().values()) {
            if (!stats.getUnlockedPlanets().contains(satellite.getParentPlanet())) continue;
            this.celestialBodyTicks.put(satellite, 0);
            this.bodiesToRender.add(satellite);
        }
        GuiCelestialSelection.BORDER_SIZE = this.field_146294_l / 65;
        GuiCelestialSelection.BORDER_EDGE_SIZE = GuiCelestialSelection.BORDER_SIZE / 4;
        for (SolarSystem solarSystem : GalaxyRegistry.getRegisteredSolarSystems().values()) {
            this.bodiesToRender.add(solarSystem.getMainStar());
        }
    }

    protected List<CelestialBody> getChildren(Object object) {
        ArrayList bodyList = Lists.newArrayList();
        Minecraft minecraft = FMLClientHandler.instance().getClient();
        EntityPlayerSP player = minecraft.field_71439_g;
        EntityPlayerSP playerBaseClient = PlayerUtil.getPlayerBaseClientFromPlayer((EntityPlayer)player, (boolean)false);
        IStatsClientCapability stats = null;
        if (player != null) {
            stats = (IStatsClientCapability)playerBaseClient.getCapability(CapabilityStatsClientHandler.PP_STATS_CLIENT_CAPABILITY, null);
        }
        if (object instanceof Planet) {
            List moons = GalaxyRegistry.getMoonsForPlanet((Planet)((Planet)object));
            for (Moon moon : moons) {
                if (!stats.getUnlockedPlanets().contains(moon)) continue;
                bodyList.add(moon);
            }
        } else if (object instanceof SolarSystem) {
            List planets = GalaxyRegistry.getPlanetsForSolarSystem((SolarSystem)((SolarSystem)object));
            for (Planet planet : planets) {
                if (!stats.getUnlockedPlanets().contains(planet)) continue;
                bodyList.add(planet);
            }
        }
        Collections.sort(bodyList);
        return bodyList;
    }

    protected Vector3f getCelestialBodyPosition(CelestialBody cBody) {
        if (this.celestialBodyTicks.get(cBody) == null) {
            this.func_73866_w_();
        }
        return super.getCelestialBodyPosition(cBody);
    }
}

