/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.planetprogression;

import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class Config {
    public static int researchMode = 0;
    public static int worldgenStructureAmount = 0;
    public static int worldgenStructureLootAmount = 0;
    public static boolean generateResearchPaperInLoot;
    public static boolean generateResearchPaperInStructure;
    public static double telescopeTimeModifier;
    public static double satelliteControllerModifier;
    public static String[] worldgenStructureWorldWhitelist;
    public static String[] worldgenStructurePaperBlacklist;
    public static String[] dungeonPaperBlacklist;
    public static String[] preReseachedBodies;
    public static boolean showOverworldSpawnMessage;

    public static void load() {
        int i;
        Configuration config = new Configuration(new File("config/PlanetProgression.cfg"));
        config.load();
        researchMode = config.get("general settings", "Research Mode", 2, "Research Modes: 1 - Basic Research Paper Method | 2 - Basic Satellite Research Method").getInt(2);
        worldgenStructureAmount = config.get("general settings", "World Gen Structure Weight", 100, "Will be 1 in x (x = being the number in this config option), Default: 100").getInt(100);
        worldgenStructureLootAmount = config.get("general settings", "World Gen Structure Loot Spawn Weight", 10, "Will be 1 in x (x = being the number in this config option), Default: 10").getInt(10);
        generateResearchPaperInLoot = config.get("general settings", "Add Research Papers to Dungeon Loot", false, "Will add the Research Papers to spawn in Vanilla Dungeon Loot").getBoolean(false);
        generateResearchPaperInStructure = config.get("general settings", "Add Research Papers to Custom WorldGen Structure", false, "Will add the Research Papers to spawn in Custom WorldGen Structure, Note will disable structure if set to false").getBoolean(false);
        telescopeTimeModifier = config.get("general settings", "Telescope Research Time Modifier", 1.0, "Will increase the unlocking time for each paper in the telescope Default: 1.0F").getDouble(1.0);
        satelliteControllerModifier = config.get("general settings", "Satellite Controller Research Time Modifier", 1.0, "Will increase the research time for each paper for the satellite Default: 1.0F").getDouble(1.0);
        worldgenStructureWorldWhitelist = config.getStringList("Whitelist for World Gen Structure", "general settings", new String[]{"0"}, "Default: 0 | Format: dimensionID | Example: '-1 - For nether'");
        worldgenStructurePaperBlacklist = config.getStringList("Blacklist for Research Papers in World Gen Structure", "general settings", new String[0], "Format: 'planet.NAME' OR 'moon.NAME' | Example: 'planet.venus'");
        dungeonPaperBlacklist = config.getStringList("Blacklist for Research Papers in Dungeon Loot", "general settings", new String[0], "Format: 'planet.NAME' OR 'moon.NAME' | Example: 'planet.venus'");
        showOverworldSpawnMessage = config.get("general settings", "Show Overworld As been Discovered Message on first joining world/server", true, "Setting to false will disable the 'You have discovered Earth' message you get in chat when first joining a world/server").getBoolean(true);
        preReseachedBodies = config.getStringList("List of Pre-Researched Bodies", "general settings", new String[0], "Format: 'planet.NAME' OR 'moon.NAME' | Example: 'planet.venus'");
        for (i = 0; i < worldgenStructurePaperBlacklist.length; ++i) {
            Config.worldgenStructurePaperBlacklist[i] = worldgenStructurePaperBlacklist[i].toLowerCase();
        }
        for (i = 0; i < dungeonPaperBlacklist.length; ++i) {
            Config.dungeonPaperBlacklist[i] = dungeonPaperBlacklist[i].toLowerCase();
        }
        for (i = 0; i < preReseachedBodies.length; ++i) {
            Config.preReseachedBodies[i] = preReseachedBodies[i].toLowerCase();
        }
        config.save();
        if (researchMode != 1 && researchMode != 2) {
            researchMode = 2;
        }
        if (researchMode == 2) {
            generateResearchPaperInStructure = false;
        }
    }

    static {
        telescopeTimeModifier = 1.0;
        satelliteControllerModifier = 1.0;
    }
}

