/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.base;

import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.toasts.GuiToast;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import vazkii.patchouli.client.book.ClientBookRegistry;
import vazkii.patchouli.common.base.PatchouliConfig;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;

public class ClientAdvancements {
    static List<String> doneAdvancements;

    public static void setDoneAdvancements(String[] done, boolean showToast, boolean reset) {
        boolean bl = !PatchouliConfig.disableAdvancementLocking;
        doneAdvancements = Arrays.asList(done);
        ClientAdvancements.updateLockStatus(reset);
        if (showToast &= bl) {
            BookRegistry.INSTANCE.books.values().forEach(b -> {
                if (b.popUpdated() && b.showToasts) {
                    Minecraft.func_71410_x().func_193033_an().func_192988_a((IToast)new LexiconToast((Book)b));
                }
            });
        }
    }

    public static void updateLockStatus(boolean reset) {
        ClientBookRegistry.INSTANCE.reloadLocks(reset);
    }

    public static void resetIfNeeded() {
        if (doneAdvancements != null && doneAdvancements.size() > 0) {
            ClientAdvancements.setDoneAdvancements(new String[0], false, true);
        }
    }

    public static boolean hasDone(String advancement) {
        return doneAdvancements != null && doneAdvancements.contains(advancement);
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && Minecraft.func_71410_x().field_71439_g == null) {
            ClientAdvancements.resetIfNeeded();
        }
    }

    public static class LexiconToast
    implements IToast {
        final Book book;

        public LexiconToast(Book book) {
            this.book = book;
        }

        public IToast.Visibility func_193653_a(GuiToast toastGui, long delta) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_110434_K().func_110577_a(field_193654_a);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            toastGui.func_73729_b(0, 0, 0, 32, 160, 32);
            toastGui.func_192989_b().field_71466_p.func_78276_b(I18n.func_135052_a((String)this.book.name, (Object[])new Object[0]), 30, 7, -11534256);
            toastGui.func_192989_b().field_71466_p.func_78276_b(I18n.func_135052_a((String)"patchouli.gui.lexicon.toast.info", (Object[])new Object[0]), 30, 17, -16777216);
            RenderHelper.func_74520_c();
            toastGui.func_192989_b().func_175599_af().func_184391_a(null, this.book.getBookItem(), 8, 8);
            return delta >= 5000L ? IToast.Visibility.HIDE : IToast.Visibility.SHOW;
        }
    }
}

