/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import openmods.geometry.Orientation;
import openmods.inventory.IInventoryProvider;
import openmods.utils.InventoryUtils;

public class BlockUtils {
    @Deprecated
    public static EnumFacing get2dOrientation(EntityLivingBase entity) {
        return entity.func_174811_aO();
    }

    public static EnumFacing get2dOrientation(double yaw) {
        return EnumFacing.func_176731_b((int)(MathHelper.func_76128_c((double)(yaw * 4.0 / 360.0 + 0.5)) & 3));
    }

    public static float getRotationFromDirection(EnumFacing direction) {
        switch (direction) {
            case NORTH: {
                return 180.0f;
            }
            case SOUTH: {
                return 0.0f;
            }
            case WEST: {
                return 90.0f;
            }
            case EAST: {
                return -90.0f;
            }
            case DOWN: {
                return -90.0f;
            }
            case UP: {
                return 90.0f;
            }
        }
        return 0.0f;
    }

    public static float getRotationFromOrientation(Orientation orientation) {
        switch (orientation.x) {
            case POS_X: {
                return 180.0f;
            }
            case NEG_X: {
                return 0.0f;
            }
            case NEG_Z: {
                return -90.0f;
            }
            case POS_Z: {
                return 90.0f;
            }
        }
        return 0.0f;
    }

    public static EnumFacing get3dOrientation(EntityLivingBase entity, BlockPos pos) {
        if (MathHelper.func_76135_e((float)((float)entity.field_70165_t - (float)pos.func_177958_n())) < 2.0f && MathHelper.func_76135_e((float)((float)entity.field_70161_v - (float)pos.func_177952_p())) < 2.0f) {
            double entityEyes = entity.field_70163_u + (double)entity.func_70047_e();
            if (entityEyes - (double)pos.func_177956_o() > 2.0) {
                return EnumFacing.DOWN;
            }
            if ((double)pos.func_177956_o() - entityEyes > 0.0) {
                return EnumFacing.UP;
            }
        }
        return entity.func_174811_aO();
    }

    public static EntityItem dropItemStackInWorld(World worldObj, Vec3i pos, @Nonnull ItemStack stack) {
        return BlockUtils.dropItemStackInWorld(worldObj, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), stack);
    }

    public static EntityItem dropItemStackInWorld(World worldObj, double x, double y, double z, @Nonnull ItemStack stack) {
        float f = 0.7f;
        float d0 = worldObj.field_73012_v.nextFloat() * f + (1.0f - f) * 0.5f;
        float d1 = worldObj.field_73012_v.nextFloat() * f + (1.0f - f) * 0.5f;
        float d2 = worldObj.field_73012_v.nextFloat() * f + (1.0f - f) * 0.5f;
        EntityItem entityitem = new EntityItem(worldObj, x + (double)d0, y + (double)d1, z + (double)d2, stack);
        entityitem.func_174869_p();
        if (stack.func_77942_o()) {
            entityitem.func_92059_d().func_77982_d(stack.func_77978_p().func_74737_b());
        }
        worldObj.func_72838_d((Entity)entityitem);
        return entityitem;
    }

    public static EntityItem ejectItemInDirection(World world, double x, double y, double z, EnumFacing direction, @Nonnull ItemStack stack) {
        EntityItem item = BlockUtils.dropItemStackInWorld(world, x, y, z, stack);
        Vec3i v = direction.func_176730_m();
        item.field_70159_w = (float)v.func_177958_n() / 5.0f;
        item.field_70181_x = (float)v.func_177956_o() / 5.0f;
        item.field_70179_y = (float)v.func_177952_p() / 5.0f;
        return item;
    }

    public static boolean getTileInventoryDrops(TileEntity tileEntity, List<ItemStack> drops) {
        if (tileEntity == null) {
            return false;
        }
        if (tileEntity instanceof IInventory) {
            drops.addAll(InventoryUtils.getInventoryContents((IInventory)tileEntity));
            return true;
        }
        if (tileEntity instanceof IInventoryProvider) {
            drops.addAll(InventoryUtils.getInventoryContents(((IInventoryProvider)tileEntity).getInventory()));
            return true;
        }
        return false;
    }

    public static void dropInventory(IInventory inventory, World world, double x, double y, double z) {
        if (inventory == null) {
            return;
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemStack = inventory.func_70301_a(i);
            if (itemStack.func_190926_b()) continue;
            BlockUtils.dropItemStackInWorld(world, x, y, z, itemStack);
        }
    }

    public static void dropInventory(IInventory inventory, World world, int x, int y, int z) {
        BlockUtils.dropInventory(inventory, world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
    }

    public static TileEntity getTileInDirection(TileEntity tile, EnumFacing direction) {
        BlockPos offset = tile.func_174877_v().func_177972_a(direction);
        return tile.func_145831_w().func_175625_s(offset);
    }

    public static TileEntity getTileInDirection(World world, BlockPos coord, EnumFacing direction) {
        return world.func_175625_s(coord.func_177972_a(direction));
    }

    public static TileEntity getTileInDirectionSafe(World world, BlockPos coord, EnumFacing direction) {
        BlockPos n = coord.func_177972_a(direction);
        return world.func_175667_e(n) ? world.func_175625_s(n) : null;
    }

    public static AxisAlignedBB expandAround(BlockPos pos, int x, int y, int z) {
        return new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + x), (double)(pos.func_177956_o() + y), (double)(pos.func_177952_p() + z));
    }

    public static AxisAlignedBB expandAround(BlockPos pos, double x, double y, double z) {
        return new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)pos.func_177958_n() + x, (double)pos.func_177956_o() + y, (double)pos.func_177952_p() + z);
    }

    public static AxisAlignedBB aabbOffset(BlockPos pos, double x1, double y1, double z1, double x2, double y2, double z2) {
        return new AxisAlignedBB((double)pos.func_177958_n() + x1, (double)pos.func_177956_o() + y1, (double)pos.func_177952_p() + z1, (double)pos.func_177958_n() + x2, (double)pos.func_177956_o() + y2, (double)pos.func_177952_p() + z2);
    }

    public static AxisAlignedBB aabbOffset(BlockPos pos, AxisAlignedBB aabb) {
        return aabb.func_72317_d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
    }

    public static AxisAlignedBB singleBlock(BlockPos pos) {
        return new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1));
    }

    public static void playSoundAtPos(World world, BlockPos pos, SoundEvent sound, SoundCategory category, float volume, float pitch) {
        world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, sound, category, volume, pitch);
    }
}

