/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.types.multi;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import info.openmods.calc.Environment;
import info.openmods.calc.Frame;
import info.openmods.calc.executable.IExecutable;
import info.openmods.calc.executable.SymbolCall;
import info.openmods.calc.executable.Value;
import info.openmods.calc.parsing.ast.IParserState;
import info.openmods.calc.parsing.ast.ISymbolCallStateTransition;
import info.openmods.calc.parsing.ast.SameStateSymbolTransition;
import info.openmods.calc.parsing.node.IExprNode;
import info.openmods.calc.parsing.node.SymbolCallNode;
import info.openmods.calc.symbol.ICallable;
import info.openmods.calc.types.multi.Code;
import info.openmods.calc.types.multi.TypeDomain;
import info.openmods.calc.types.multi.TypedCalcUtils;
import info.openmods.calc.types.multi.TypedValue;
import info.openmods.calc.utils.OptionalInt;
import info.openmods.calc.utils.Stack;
import java.util.List;

public class DoExpressionFactory {
    private final TypeDomain domain;

    public DoExpressionFactory(TypeDomain domain) {
        this.domain = domain;
    }

    public ISymbolCallStateTransition<IExprNode<TypedValue>> createStateTransition(IParserState<IExprNode<TypedValue>> compilerState) {
        return new DoExpr(compilerState);
    }

    public void registerSymbol(Environment<TypedValue> env) {
        env.setGlobalSymbol("do", (TypedValue)((Object)new DoSymbol()));
    }

    private class DoSymbol
    implements ICallable<TypedValue> {
        private DoSymbol() {
        }

        @Override
        public void call(Frame<TypedValue> frame, OptionalInt argumentsCount, OptionalInt returnsCount) {
            Preconditions.checkState((boolean)argumentsCount.isPresent(), (Object)"'do' symbol requires arguments count");
            Integer argCount = argumentsCount.get();
            Preconditions.checkState((argCount > 1 ? 1 : 0) != 0, (Object)"'do' expects at least one argument");
            Stack<TypedValue> stack = frame.stack().substack(argCount);
            for (TypedValue expr : ImmutableList.copyOf(stack)) {
                stack.clear();
                Code exprCode = expr.as(Code.class);
                exprCode.execute(frame);
            }
            TypedCalcUtils.expectExactReturnCount(returnsCount, stack.size());
        }
    }

    private class DoExpr
    extends SameStateSymbolTransition<IExprNode<TypedValue>> {
        public DoExpr(IParserState<IExprNode<TypedValue>> parentState) {
            super(parentState);
        }

        @Override
        public IExprNode<TypedValue> createRootNode(List<IExprNode<TypedValue>> children) {
            return new DoNode(children);
        }
    }

    private class DoNode
    extends SymbolCallNode<TypedValue> {
        public DoNode(List<IExprNode<TypedValue>> args) {
            super("do", args);
        }

        @Override
        public void flatten(List<IExecutable<TypedValue>> output) {
            int argCount = 0;
            for (IExprNode<TypedValue> iExprNode : this.getChildren()) {
                output.add(Value.create(Code.flattenAndWrap(DoExpressionFactory.this.domain, iExprNode)));
                ++argCount;
            }
            Preconditions.checkState((argCount > 1 ? 1 : 0) != 0, (Object)"'do' expects at least one argument");
            output.add(new SymbolCall(this.symbol, argCount, 1));
        }
    }
}

