/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc;

import info.openmods.calc.Calculator;
import info.openmods.calc.Compilers;
import info.openmods.calc.Environment;
import info.openmods.calc.ICompilerMapFactory;
import info.openmods.calc.IValuePrinter;
import info.openmods.calc.executable.Operator;
import info.openmods.calc.executable.OperatorDictionary;
import info.openmods.calc.parsing.IValueParser;
import info.openmods.calc.symbol.GenericFunctions;

public abstract class SimpleCalculatorFactory<E, M> {
    protected abstract E getNullValue();

    protected Environment<E> createEnvironment() {
        return new Environment<E>(this.getNullValue());
    }

    protected abstract IValueParser<E> getValueParser();

    protected abstract IValuePrinter<E> createValuePrinter();

    protected abstract void configureEnvironment(Environment<E> var1);

    protected abstract void configureOperators(OperatorDictionary<Operator<E>> var1);

    public Calculator<E, M> create(ICompilerMapFactory<E, M> compilersFactory) {
        OperatorDictionary<Operator<E>> operators = new OperatorDictionary<Operator<E>>();
        this.configureOperators(operators);
        Environment<E> env = this.createEnvironment();
        GenericFunctions.createStackManipulationFunctions(env);
        this.configureEnvironment(env);
        Compilers<E, M> compilers = compilersFactory.create(this.getNullValue(), this.getValueParser(), operators, env);
        IValuePrinter<E> printer = this.createValuePrinter();
        return new Calculator<E, M>(env, compilers, printer);
    }
}

